<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class StockAdjustController extends Controller
{
    public function index($xvmatcode = null)
    {

        $HDMat = DB::table('tdoctAjhd')
            ->leftJoin('vk2_users', 'tdoctAjhd.users_id', '=', 'vk2_users.id')
            ->orderBy('XVAjhDocNo', 'DESC')
            ->get();
        $data = [
            'HD' => $HDMat,
        ];
        return view('StockAdjust.index', $data);
    }
    public function Approveindex($xvmatcode = null)
    {

        $HDMat = DB::table('tdoctAjhd')
            ->leftJoin('vk2_users', 'tdoctAjhd.users_id', '=', 'vk2_users.id')
            ->orderBy('XVAjhDocNo', 'DESC')
            ->where('XVAjhDocStatus','2')
            ->get();
        $data = [
            'HD' => $HDMat,
        ];
        return view('StockAdjust.index', $data);
    }
    public function FormInsert()
    {
        $dataSend = [
        ];
        return view('StockAdjust.frm_add', $dataSend);
    }

    public function FormEdit($DocNo)
    {
        $hd = DB::table('tdoctAjhd')->where('XVAjhDocNo', '=', $DocNo)->first();
        $dt = DB::table('tdoctAjdt')
            ->where('XVAjhDocNo', '=', $DocNo)
            ->leftJoin('tmstmmaterial', 'tdoctAjdt.xvmatcode', '=', 'tmstmmaterial.xvmatcode')
            ->leftJoin('tmstmunit', 'tdoctAjdt.xvuntcode', '=', 'tmstmunit.xvuntcode')
            ->get();
        foreach ($dt as $item) {
            $item->unitType = DB::table('tmstmmat_unit')
                ->where('xvmatcode', '=', $item->xvmatcode)
                ->leftjoin('tmstmunit', 'tmstmunit.xvuntcode', 'tmstmmat_unit.xvuntcode')
                ->get()->toArray();
            $summary = DB::table('tstktmatstockcard')
                ->where('xvmatcode', '=', $item->xvmatcode)
                ->select(DB::raw('SUM(xistkqtyleft) as SumQty'))
                ->first();
            $item->qty = $summary->SumQty ?? 0;
        }
        $dataSend = [
            'hd' => $hd,
            'dt' => $dt,
            'DocStatus' => $hd->XVAjhDocStatus,
        ];
        return view('StockAdjust.frm_edit', $dataSend);
    }

    public function Store(Request $request)
    {
        $date = Carbon::createFromFormat('d-m-Y', $request->XDAjhDocDate);
        try {
            DB::beginTransaction();
            $docNo = GeneratePrimaryKeyDate('tdoctajhd', 'XVAjhDocNo', 'AJ', 2);

            DB::table('tdoctAjhd')->insert([
                'XVAjhDocNo' => $docNo,
                'XDAjhDocDate' => $date->format('Y-m-d'),
                'XVAjhDocStatus' => '1',
                'XVAjhDocRmk' => $request->XVAjhDocRmk,
                'users_id' => $request->SelectUsers,
            ]);
            for ($i = 0; $i < count($request->xvmatcode); $i++) {
                $MatUnit = DB::table('tmstmmat_unit')
                    ->where('xvmatcode', '=', $request->xvmatcode[$i])
                    ->where('tmstmmat_unit.xvuntcode', '=', $request->xvuntcode[$i])
                    ->join('tmstmunit', 'tmstmmat_unit.xvuntcode', 'tmstmunit.xvuntcode')
                    ->first();
//                $Summary =DB::table('tstktmatstockcard')
//                    ->where('xvmatcode', '=', $request->xvmatcode[$i])
//                    ->select(DB::raw('SUM(xistkqtyleft) as SumQty'))
//                    ->first();
//                if($Summary->SumQty==null){
//                    $Summary->SumQty = 0 ;
//                }
                $qtyStk = $request->XIAjdQty[$i] * $MatUnit->ximunfactor;
//                $inStockLessThanDB = false;
//                if($qtyStk >= $Summary->SumQty){
//                    $inStockLessThanDB = true;
//                }
//                dd($request->all(),$date,$docNo,$MatUnit,$qtyStk,$Summary,$inStockLessThanDB);

                DB::table('tdoctajdt')->insert([
                    'XVAjhDocNo' => $docNo,
                    'xvmatcode' => $request->xvmatcode[$i],
                    'xvuntcode' => $request->xvuntcode[$i],
                    'XIAjdQty' => $request->XIAjdQty[$i],
                    'XVAjdUnitName' => $MatUnit->xvuntname,
                    'XIAjdFactor' => $MatUnit->ximunfactor,
                    'XIAjdQtyLeft' => $request->XIAjdQty[$i] - $request->XIAjdQtyPo[$i],
                    'XIAjdQtyStk' => $qtyStk,
//                    'XFAjdUnitCost' => $request->XFPodUnitCost[$i],
//                    'XFAjdDiscount' => $request->XFPodDiscount[$i],
//                    'XFAjdCostTotal' => $request->XFPodCostTotal[$i],
//                    'XFAjdCostAvg' => $request->XFPodCostTotal[$i] / $qtyStk,
                ]);
            }
            DB::commit();
            return redirect()->route('adj.edit', ['DocNo' => $docNo])->with('msg', 'success');

        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }

    public function Update(Request $request)
    {
        $date = Carbon::createFromFormat('d-m-Y', $request->XDAjhDocDate);
        try {
            DB::beginTransaction();
            $docNo = $request->XVAjhDocNo;

            DB::table('tdoctAjhd')
                ->where('XVAjhDocNo', '=', $docNo)
                ->update([
                    'XDAjhDocDate' => $date->format('Y-m-d'),
                    'XVAjhDocStatus' => '1',
                    'XVAjhDocRmk' => $request->XVAjhDocRmk,
                    'users_id' => $request->SelectUsers,
                ]);
            $dt = DB::table('tdoctAjdt')
                ->where('XVAjhDocNo', '=', $docNo)
                ->delete();
            for ($i = 0; $i < count($request->xvmatcode); $i++) {
                $MatUnit = DB::table('tmstmmat_unit')
                    ->where('xvmatcode', '=', $request->xvmatcode[$i])
                    ->where('tmstmmat_unit.xvuntcode', '=', $request->xvuntcode[$i])
                    ->join('tmstmunit', 'tmstmmat_unit.xvuntcode', 'tmstmunit.xvuntcode')
                    ->first();
//                $Summary =DB::table('tstktmatstockcard')
//                    ->where('xvmatcode', '=', $request->xvmatcode[$i])
//                    ->select(DB::raw('SUM(xistkqtyleft) as SumQty'))
//                    ->first();
//                if($Summary->SumQty==null){
//                    $Summary->SumQty = 0 ;
//                }
                $qtyStk = $request->XIAjdQty[$i] * $MatUnit->ximunfactor;
//                $inStockLessThanDB = false;
//                if($qtyStk >= $Summary->SumQty){
//                    $inStockLessThanDB = true;
//                }
//                dd($request->all(),$date,$docNo,$MatUnit,$qtyStk,$Summary,$inStockLessThanDB);

                DB::table('tdoctajdt')->insert([
                    'XVAjhDocNo' => $docNo,
                    'xvmatcode' => $request->xvmatcode[$i],
                    'xvuntcode' => $request->xvuntcode[$i],
                    'XIAjdQty' => $request->XIAjdQty[$i],
                    'XVAjdUnitName' => $MatUnit->xvuntname,
                    'XIAjdFactor' => $MatUnit->ximunfactor,
                    'XIAjdQtyLeft' => $request->XIAjdQty[$i] - $request->XIAjdQtyPo[$i],
                    'XIAjdQtyStk' => $qtyStk,
//                    'XFAjdUnitCost' => $request->XFPodUnitCost[$i],
//                    'XFAjdDiscount' => $request->XFPodDiscount[$i],
//                    'XFAjdCostTotal' => $request->XFPodCostTotal[$i],
//                    'XFAjdCostAvg' => $request->XFPodCostTotal[$i] / $qtyStk,
                ]);
            }
            DB::commit();
            return redirect()->route('adj.edit', ['DocNo' => $docNo])->with('msg', 'success');

        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }

    public function ChangeStatus(Request $request)
    {
        try {
            DB::beginTransaction();
            $docNo = $request->XVAjhDocNo;
            $requestChange = $request->eventRequest;
            $HD = DB::table('tdoctAjhd')
                ->where('XVAjhDocNo', '=', $docNo)
                ->first();
            $DocStatus = $HD->XVAjhDocStatus;

            switch ($requestChange) {
                case '2' : // Ask for Approve
                    if (canItBeSave($DocStatus)) {
                        $this->UpdateStatus($docNo, $requestChange);
                    } else {
                        // Can't Update Status Because DocStatus Isn't 1 or 4
                        // Do Someting
                    }
                    break;
                case '3' :  // Approve

                    if (canItBe_Approve_RequestChange($DocStatus)) {
                        $isNotBalancePreviosMonth = checkBalancePreviousMonth();
                        if($isNotBalancePreviosMonth){
                            return redirect()->back()->with('msg', 'IsNotBalanced');
                        }
                        $this->UpdateStatus($docNo, $requestChange);
                        $dt = DB::table('tdoctAjdt')
                            ->where('XVAjhDocNo', '=', $docNo)
                            ->get();
                        foreach ($dt as $item) {
                            $Summary = DB::table('tstktmatstockcard')
                                ->where('xvmatcode', '=', $item->xvmatcode)
                                ->select(DB::raw('SUM(xistkqtyleft) as SumQty'))
                                ->first();
                            $lastPrice = DB::table('tstktmatstockcard')
                                ->where('xvmatcode', '=', $item->xvmatcode)
                                ->first();
                            if ($lastPrice == null) {
                                $lastPrice = DB::table('tmstmmat_unit')
                                    ->where('xvmatcode', '=', $item->xvmatcode)
                                    ->where('xvuntcode', '=', $item->xvuntcode)
                                    ->first();
                                $price = $lastPrice->xfmunprice;
                            } else {
                                $price = $lastPrice->xfstkcost;
                            }

                            $Summary = intval($Summary->SumQty) ?? 0;
                            if ($item->XIAjdQtyStk > $Summary) {
                                $qtyleft = $item->XIAjdQtyStk - $Summary;
                                $is_LessThan = false; //default case 5
                            } else {
                                $qtyleft = ($Summary - $item->XIAjdQtyStk);
                                $is_LessThan = true;  // case 6
                            }
                            $item->tempQty = $qtyleft;
//                            $item->Cost = 0;
//                            dd($item, $is_LessThan, $qtyleft, $price);

                            if ($is_LessThan) {
                                //Case 6 === Case 2
                                $itemStockMat = DB::table('tstktmatstockcard')
                                    ->where('xvmatcode', '=', $item->xvmatcode)
//                                    ->whereIn('xvstktype', [1, 5])
                                    ->where('xistkqtyleft', '>', 0)
                                    ->get();
                                foreach ($itemStockMat as $keySTK => $itemSTK) {
                                    if ($itemSTK->xistkqtyleft >= $item->tempQty) {
                                        DB::table('tstktmatstockcard')
                                            ->where('xvmatcode', '=', $itemSTK->xvmatcode)
                                            ->where('xvstkdocno', '=', $itemSTK->xvstkdocno)
                                            ->where('xvstktype', '=', $itemSTK->xvstktype)
                                            ->update([
                                                'xistkqtyuse' => $itemSTK->xistkqtyuse + $item->tempQty,
                                                'xistkqtyleft' => $itemSTK->xistkqtyleft - $item->tempQty,
                                            ]);
//                                        $item->Cost = $item->Cost + ($itemSTK->xfstkcost * $item->tempQty);
                                        $item->tempQty = 0;
                                    } else {
//                                    dd($itemSTK, $item, 'es');

                                        DB::table('tstktmatstockcard')
                                            ->where('xvmatcode', '=', $itemSTK->xvmatcode)
                                            ->where('xvstkdocno', '=', $itemSTK->xvstkdocno)
                                            ->where('xvstktype', '=', $itemSTK->xvstktype)
                                            ->update([
                                                'xistkqtyuse' => $itemSTK->xistkqty,
                                                'xistkqtyleft' => 0,
                                            ]);
//                                        $item->Cost = $item->Cost + ($itemSTK->xfstkcost * $itemSTK->xistkqtyleft);
                                        $item->tempQty = $item->tempQty - $itemSTK->xistkqtyleft;
                                    }
                                    if ($item->tempQty <= 0) {
                                        break;
                                    }
                                }
//                                if (count($itemStockMat) == 0) {
//                                    $getDefaultCost = DB::table('tmstmmat_unit')
//                                        ->where('xvmatcode', '=', $item->xvmatcode)
//                                        ->where('xvuntcode', '=', $item->xvuntcode)
//                                        ->first();
//                                    $item->Cost = $getDefaultCost->xfmunprice;
////                                dd(count($itemStockMat), $item,$getDefaultCost);
//                                }else{
//                                    $item->Cost = divnum($item->Cost, $qtyleft);
//                                }
                                DB::table('tstktmatstockcard')
                                    ->insert([
                                        'xvmatcode' => $item->xvmatcode,
                                        'xvstkdocno' => $docNo,
                                        'xvstktype' => 6,
                                        'xistkqty' => $qtyleft,
                                        'xistkqtyuse' => 0,
                                        'xistkqtyleft' => $qtyleft < 0 ? -$qtyleft : 0,
                                        'xfstkcost' => $price,
                                        'xdstkdate' => $HD->XDAjhDocDate,
                                    ]);
                            } else {
                                //Case 5 === Case 1
                                $itemStockMat = DB::table('tstktmatstockcard')
                                    ->where('xvmatcode', '=', $item->xvmatcode)
                                    ->whereIn('xvstktype', [2, 6])
                                    ->where('xistkqtyleft', '!=', 0)
                                    ->get();
                                foreach ($itemStockMat as $keySTK => $itemSTK) {
                                    if ($itemSTK->xistkqtyleft + $item->tempQty >= 0) {
                                        $qtyLeftSTK = 0;
                                        $item->tempQty = $itemSTK->xistkqtyleft + $item->tempQty;
                                    } else {
                                        $qtyLeftSTK = $itemSTK->xistkqtyleft + $item->tempQty;
                                        $item->tempQty = 0;
                                    }
                                    DB::table('tstktmatstockcard')
                                        ->where('xvmatcode', '=', $itemSTK->xvmatcode)
                                        ->where('xvstkdocno', '=', $itemSTK->xvstkdocno)
                                        ->where('xvstktype', '=', $itemSTK->xvstktype)
                                        ->update([
                                            'xistkqtyleft' => $qtyLeftSTK,
                                        ]);
                                    if ($item->tempQty <= 0) {
                                        break;
                                    }
                                }
                                DB::table('tstktmatstockcard')
                                    ->insert([
                                        'xvmatcode' => $item->xvmatcode,
                                        'xvstkdocno' => $docNo,
                                        'xvstktype' => 5,
                                        'xistkqty' => $qtyleft,
                                        'xistkqtyuse' => $qtyleft - $item->tempQty,
                                        'xistkqtyleft' => $item->tempQty,
                                        'xfstkcost' => $price,
                                        'xdstkdate' => $HD->XDAjhDocDate,
                                    ]);

                            }
//                            DB::table('tstktmatstockcard')
//                                ->insert([
//                                    'xvmatcode'=>$item->xvmatcode,
//                                    'xvstkdocno'=>$docNo,
//                                    'xvstktype'=>$is_LessThan ? 6 : 5,
//                                    'xistkqty'=>0,
//                                    'xistkqtyuse'=>0,
//                                    'xistkqtyleft'=>$qtyleft,
//                                    'xfstkcost'=>$price ,
//                                    'xdstkdate'=>$HD->XDAjhDocDate,
//                                ]);

                            DB::table('tdoctajdt')
                                ->where('XVAjhDocNo', '=', $item->XVAjhDocNo)
                                ->where('xvmatcode', '=', $item->xvmatcode)
                                ->where('xvuntcode', '=', $item->xvuntcode)
                                ->update([
                                    'XIAjdQtyStkBefore' => $Summary,
                                    'XIAjdQtyAdjust'=>$qtyleft
                                ]);
                        }
                    } else {
                        // Can't Update Status Because DocStatus Isn't 2
                        // Do Someting
                    }
                    break;
                case '4' : // Requeste Change
                    if (canItBe_Approve_RequestChange($DocStatus)) {
                        $this->UpdateStatus($docNo, $requestChange);
                    } else {
                        // Can't Update Status Because DocStatus Isn't 2
                        // Do Someting
                    }
                    break;
                case '5' :
                    if (canItBe_Cancle($DocStatus)) {
                        $this->UpdateStatus($docNo, $requestChange);
                    } else {
                        // Can't Update Status Because DocStatus Isn't ( 1 , 2 , 4)
                        // Do Someting
                    }
                case '6' :
                    if (canItBe_Expire($DocStatus)) {
                        $this->UpdateStatus($docNo, $requestChange);
                    } else {
                        // Can't Update Status Because DocStatus Isn't ( 3)
                        // Do Someting
                    }
                    break;
            }
            DB::commit();
            return redirect()->back();
        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }
    }

    public function UpdateStatus($docNo, $docStatus)
    {
        DB::table('tdoctajhd')
            ->where('XVAjhDocNo', '=', $docNo)
            ->update([
                'XVAjhDocStatus' => $docStatus
            ]);
    }

}
