<?php

namespace App\Http\Controllers;

use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class StockcardProductController extends Controller
{
    public function index(Request $request)
    {
        $HD = DB::table('tstktmatstockcardproduct')
            ->leftJoin('tmstmproduct', 'tstktmatstockcardproduct.xvpdtcode', 'tmstmproduct.xvpdtcode');
        if (isset($request->xvpdtcode)&&$request->xvpdtcode != null) {
            $HD = $HD
                ->orderBy('id', 'asc')
                ->where('tstktmatstockcardproduct.xvpdtcode','=',$request->xvpdtcode);
        }else{
            $HD = $HD
                ->orderBy('id', 'desc');
        }
        if(isset($request->DateStart) && isset($request->DateEnd)){
            $HD = condition_LCRVOutide($HD, 'xdstkdate', false, $request->DateStart, $request->DateEnd);
        }

        $HD = $HD->get();
        $monthWithoutBalance = checkBalancePreviousMonth("tstktmatstockcardproduct");
        $HDMat = DB::table('tmstmproduct')
            ->orderBy('xvpdtcode', 'DESC')
            ->get();
        $data = [
            'HD' => $HD,
            'HDMat'=>$HDMat,
            'xvpdtcode'=>$request->xvpdtcode?? null,
            'DateStart'=>$request->DateStart ?? null,
            'DateEnd'=>$request->DateEnd?? null,
            'monthWithoutBalance' => $monthWithoutBalance
        ];
        return view('StockcardProduct.index', $data);
    }

    public function Balance(Request $request)
    {
        try {
            DB::beginTransaction();

            $start = new Carbon('first day of last month');
            $end = new Carbon('last day of last month');
            $today = new Carbon('first day of this month');
            $startPrevious = $start->format('Y-m-d');
            $endPrevious = $end->format('Y-m-d');
            $todayME = $today->format('Y-m-d');
            $prefix = twoprefixYearMonth();
            $docNo = "ME" . $prefix;
//            INSERT INTO tstktmatstockcardproduct(xvstkdocno,xvpdtcode,xvpszname,xvstktype,xistkqty,xistkqtyuse,xistkqtyleft,xfstkcost,xdstkdate)
            $sql = "
                                        SELECT  '$docNo' AS xvstkdocno,xvpdtcode,xvpszname,'0' AS xvstktype,SUM(xistkqtyleft) AS xistkqty,0 AS xistkqtyuse,SUM(xistkqtyleft) AS xistkqtyleft
                                        ,CASE  WHEN SUM(xistkqtyleft)>0 THEN SUM((xistkqtyleft*xfstkcost))/SUM(xistkqtyleft)
                                         WHEN SUM(xistkqtyleft)=0 THEN 0
                                         WHEN SUM(xistkqtyleft)<0 THEN ABS(SUM((xistkqtyleft*xfstkcost))/SUM(xistkqtyleft))
                                        END AS xfstkcost
                                        ,'$todayME' as xdstkdate
                                        FROM tstktmatstockcardproduct
                                        WHERE xdstkdate BETWEEN '$startPrevious' AND '$endPrevious'
                                        GROUP BY xvpdtcode,xvpszname";
            $query = DB::select($sql);
            foreach ($query as $item) {
                DB::table('tstktmatstockcardproduct')
                    ->where('xvpdtcode', '=', $item->xvpdtcode)
                    ->where('xvpszname', '=', $item->xvpszname)
                    ->whereBetween('xdstkdate', [$startPrevious, $endPrevious])
                    ->update([
                        'xistkqtyuse' => DB::raw('xistkqty'),
                        'xistkqtyleft' => 0,
                    ]);
                $hasOldME = DB::table('tstktmatstockcardproduct')
                    ->where('xvpdtcode', '=', $item->xvpdtcode)
                    ->where('xvpszname', '=', $item->xvpszname)
                    ->where('xvstkdocno', '=', $item->xvstkdocno)
                    ->where('xvstktype', '=', $item->xvstktype)
                    ->first();
//                dd($query,$item,$hasOldME);
                if ($hasOldME) {
                    $costNew = ($item->xistkqty *$item->xfstkcost);
                    $costOld = $hasOldME->xistkqty *$hasOldME->xfstkcost;
                    $totalQty = $item->xistkqty + $hasOldME->xistkqty;
                    $stkcost= ($costNew+$costOld)/$totalQty;
                    DB::table('tstktmatstockcardproduct')
                        ->where('xvpdtcode', '=', $item->xvpdtcode)
                        ->where('xvpszname', '=', $item->xvpszname)
                        ->where('xvstkdocno', '=', $item->xvstkdocno)
                        ->where('xvstktype', '=', $item->xvstktype)
                        ->delete();
                    DB::table('tstktmatstockcardproduct')
                        ->where('xvpdtcode', '=', $item->xvpdtcode)
                        ->where('xvpszname', '=', $item->xvpszname)
                        ->where('xvstkdocno', '=', $item->xvstkdocno)
                        ->where('xvstktype', '=', $item->xvstktype)
                        ->insert([
                            'xvpdtcode'=>$item->xvpdtcode,
                            'xvpszname'=>$item->xvpszname,
                            'xvstkdocno' => $item->xvstkdocno,
                            'xvstktype' => $item->xvstktype,

                            'xistkqty' => $totalQty,
                            'xistkqtyuse' => $item->xistkqtyuse + $hasOldME->xistkqtyuse,
                            'xistkqtyleft' => $item->xistkqtyleft + $hasOldME->xistkqtyleft,
                            'xfstkcost' => $stkcost,
                            'xdstkdate' => $item->xdstkdate ,
                        ]);
                } else {
                    DB::table('tstktmatstockcardproduct')->insert([
                        'xvpdtcode'=>$item->xvpdtcode,
                        'xvpszname'=>$item->xvpszname,
                        'xvstkdocno' => $item->xvstkdocno,
                        'xvstktype' => $item->xvstktype,
                        'xistkqty' => $item->xistkqty,
                        'xistkqtyuse' => $item->xistkqtyuse,
                        'xistkqtyleft' => $item->xistkqtyleft,
                        'xfstkcost' => $item->xfstkcost,
                        'xdstkdate' => $item->xdstkdate,
                    ]);
                }
            }

//            $HD = DB::table('tstktmatstockcardproduct')
//                ->where('xvstktype', '!=', '0')
//                ->whereBetween('xdstkdate', [$startPrevious, $endPrevious])
//                ->delete();
            DB::commit();
//            dd($startPrevious, $endPrevious, $docNo,$sql,$todayME,$query,$HD);
            return redirect()->back();
        } catch (\Exception $e) {
            DB::rollback();
            dd($e);
            abort(500, 'Internal error');
        }

    }
    public function SumQty($xvpdtcode)
    {
        dd('unused?');
    }
}
