<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class SupplierController extends Controller
{
    public function index()
    {
        $spl = DB::table('tmstmsupplier')->orderBy('XVSplCode', 'DESC')->get()->toArray();
        $data = [
            'spls' => $spl,
        ];
        return view('supplier.index', $data);
    }

    public function add_supplier(Request $request)
    {
        DB::beginTransaction();
        try {
            $isDuplicate = $this->checkNameDuplicate($request->XVSplName);
            if($isDuplicate){
                return redirect()->route('supplier')->with('msg', 'Duplicate');
            }
            $code = GeneratePrimaryKeyDate('tmstmsupplier','XVSplCode','Spl');
            DB::table('tmstmsupplier')->insert([
                'XVSplCode' => $code,
                'XVSplName' => $request->XVSplName,
                'XVSplTaxID' => $request->XVSplTaxID,
                'XVSplAddress' => $request->XVSplAddress,
                'xvsqlcontactname' => $request->xvsqlcontactname,
                'XVSplEmail' => $request->XVSplEmail,
                'XVSplPhone' => $request->XVSplPhone,
                'XVSplFax' => $request->XVSplFax
            ]);
            DB::commit();

            return redirect()->route('supplier')->with('msg', 'success');
        } catch (\Exception $e) {
            DB::rollback();
            abort(500, 'Internal error');
        }
    }

    public function frmEdit($id)
    {
        $spl = DB::table('tmstmsupplier')->where('XVSplCode', $id)->first();
        $data = ['spl' => $spl];
        return view('supplier.frm_edit_sup', $data);
    }

    public function edit_supplier(Request $request)
    {

        DB::beginTransaction();
        try {
            $isDuplicate = $this->checkNameDuplicate($request->XVSplName);
            if($isDuplicate){
                return redirect()->route('supplier')->with('msg', 'Duplicate');
            }
            DB::table('tmstmsupplier')->where('XVSplCode', $request->XVSplCode)->update([
                'XVSplCode' => $request->XVSplCode,
                'XVSplName' => $request->XVSplName,
                'XVSplTaxID' => $request->XVSplTaxID,
                'XVSplAddress' => $request->XVSplAddress,
                'xvsqlcontactname' => $request->xvsqlcontactname,
                'XVSplEmail' => $request->XVSplEmail,
                'XVSplPhone' => $request->XVSplPhone,
                'XVSplFax' => $request->XVSplFax
            ]);
            DB::commit();

            return redirect()->route('supplier')->with('msg', 'success');
        } catch (\Exception $e) {
            DB::rollback();
            abort(500, 'Internal error');
        }
    }

    public function delSupplier($id)
    {
        DB::beginTransaction();
        try {
            $SupplierInMaterial = DB::table('tmstmmaterial')->where('xvsplcode','=',$id)->count();
            $SupplierInPo = DB::table('TDocTPoHD')->where('XVSplCode','=',$id)->count();
            if($SupplierInMaterial > 0 || $SupplierInPo > 0){
                return redirect()->route('supplier')->with('msg', 'busy');
            }
            DB::table('tmstmsupplier')->where('XVSplCode', $id)->delete();
            DB::commit();
            return redirect()->route('supplier')->with('msg', 'success');
        } catch (\Exception $e) {
            DB::rollback();
            abort(500, 'Internal error');
        }
    }

    public function viewSupplier($id)
    {
        $spl = DB::table('tmstmsupplier')->where('XVSplCode', $id)->first();
        // $mat = DB::table('tmstmmaterial')->where('xvsplcode',$id)->get()->toArray();
        $mat = DB::table('tmnymmatsup') 
             ->leftjoin('tmstmmaterial', 'tmstmmaterial.xvmatcode', 'tmnymmatsup.xvmatcode')
            ->leftjoin('tmstmmattype', 'tmstmmattype.xvmtycode', 'tmstmmaterial.xvmtycode')
            ->leftjoin('tmstmmatgroup', 'tmstmmatgroup.xvmgpcode', 'tmstmmaterial.xvmgpcode')
            ->where('tmnymmatsup.XVSplCode', $id)
            ->get()->toArray();
        $data = [
            'spl' => $spl,
            'mats' => $mat,
        ];
        return view('supplier.viewdetail', $data);
    }

    public function genCode()
    {

        $spl = DB::table('tmstmsupplier')->orderBy('XVSplCode', 'DESC')->first();
        if ($spl == null) {
            $num = 1;
        } else {
            $num = substr($spl->XVSplCode, -3) + 1;
        }
        $splId = sprintf('Spl-' . '%03d', $num);
        return $splId;
    }

    public function checkNameDuplicate($name){
        $Cst = DB::table('tmstmsupplier')->where('XVSplName', $name)->count();
        return $Cst>0;
    }
}
