// import {selfRowTotal} from'./LogicCalculate.js'

$(document).ready(function () {
    handleUITax();
    $('#datepicker').datepicker({
        uiLibrary: 'bootstrap4',
        format: 'dd-mm-yyyy',
        // change: function (e) {
        // }
    });
    $('#XDPohDocDateReceive').datepicker({
        uiLibrary: 'bootstrap4',
        format: 'dd-mm-yyyy'
    });

    function DateDiff(date1,date2){

    }
    let DT = $('#SelectMaterial').on('select2:select', function (e) {
        var {id,text} = (e.params.data);
        let unitType = JSON.parse(e.params.data?.element?.attributes[1]?.nodeValue)  ?? [];
        createRowTable(id,text,unitType)
    });
    window.TriggerChange = function(oldArr){
        DT.val(oldArr).trigger("change");
    }

});
function createRowTable(id,text,unitType){
    let str = text.replace(/ /g, '');
    str = replaceQuotes(str);
    let txt = str.split(":");
    let unitOption = renderOption(unitType,'xvuntcode','xvuntname','xfmunprice')
    let defualtPrice = parseFloat(unitType[0].xfmunprice).toFixed(2)
    const Control = document.getElementById("Control")
    Control.insertAdjacentHTML('beforebegin',`
                                <tr id="${id}" class="dtItems">
                                    <th scope="row">${txt[0]}</th>
                                    <th scope="row">${txt[1]}</th>
                                    <th >
                                    <select class="form-control"  name="XVMatUnit_Name[]"   onchange="setDefaultPrice(this,'${id}')">
                                        ${unitOption}
                                    </select>
                                    </th>
                                    <td>
                                        <input type="text" class="form-control text-right" name="XIPodQty[]" onkeypress='return isNumberKeyNoDot(event)' onchange="RowValChange('${id}')" min="1" value="1"/>
                                    </td>
                                    <td>
                                        <input type="text" class="form-control text-right" name="XFPodUnitCost[]" onkeypress='return isNumberKey(event)' onchange="RowValChange('${id}')" min="1" value="${defualtPrice}"/>
                                    </td>
                                    <td style="display: none" >
                                        <input type="text" class="form-control text-right" name="XFPodDiscount[]" onkeypress='return isNumberKey(event)' onchange="RowValChange('${id}')" min="0" value="0"/>
                                    </td>
                                    <td id="Child_Display" class="text-right" >
                                    </td>
                                    <td class="text-center">
                                        <button type="button" class="btn btn-danger btn-circle btn-sm" onclick="removeRow('${id}')">X</button>
                                    </td>
                                    <input type="hidden" name="xvmatcode[]" value="${id}">
                                    <input type="hidden" name="XVPodName[]" value="${txt[1]}">
                                    <input type="hidden" class="form-control" name="XFPodCostTotal[]" readonly/>
                                </tr>`)
    ReRenderAll();
}
function setDefaultPrice(e,parentID){
    let item = document.getElementById(`option_${e.value}`)
    let parent = document.getElementById(parentID);
    let XFPodUnitCost = parent.querySelector("input[name='XFPodUnitCost[]']"); // 10
    XFPodUnitCost.value = item.getAttribute("data-custom")
    ReRenderAll();
}
function renderOption(arr,key,text,custom){
    let options = ""
    for(let i = 0 ; i<arr.length ; i++){
        options+=`<option id="option_${arr[i][key]}" value="${arr[i][key]}" data-custom="${arr[i][custom]}">${arr[i][text]}</option>`
    }
    return options
}
function removeRow(id){
    document.getElementById(id).remove();
    updateCurrentDT()
}
function updateCurrentDT(){
    var oldList = document.getElementsByClassName("dtItems")
    let oldArr = [];
    for(let i = 0 ; i < oldList.length; i++){
        oldArr.push(oldList[i].id)
    }
    TriggerChange(oldArr)

}
function ReRenderAll(){
    var dtItems = document.getElementsByClassName("dtItems")
    for (var i = 0; i < dtItems.length; i++) {
        RowValChange(dtItems[i].id)
    }
}
function RowValChange(parentID){
    let parent = document.getElementById(parentID);
    let XIPodQty = parent.querySelector("input[name='XIPodQty[]']"); // 7
    let XFPodUnitCost = parent.querySelector("input[name='XFPodUnitCost[]']"); // 10
    let XFPodCostTotal = parent.querySelector("input[name='XFPodCostTotal[]']"); //11 = 7 * 10
    let XFPodDiscount = parent.querySelector("input[name='XFPodDiscount[]']");
    let Child_Display = parent.querySelector("#Child_Display");

    let CostTotal =  selfRowTotal(XIPodQty.value , XFPodUnitCost.value,XFPodDiscount.value)
    Child_Display.innerHTML  = formatMoney(CostTotal);
    XFPodCostTotal.value = CostTotal;
    updateExtraRow("XIPohAmount","XIPodQty[]",'F_XIPohAmount');
    updateExtraRow("XFPohTotal","XFPodCostTotal[]",'F_XFPohTotal');
    updateBeforeVat()
    BillDiscount();
    TotalVat()
    calculateCost();
}
function VatCase(){
    ReRenderAll();
}

function includeTax(){
    handleUITax();
    VatCase();
    TotalVat();
    calculateCost();
}
function updateExtraRow(id,NameElement,hiddenField = null){
    let Row = document.getElementById(id);
    let Value = SumArray(getArrayInput(NameElement))
    if (hiddenField != null){
        let hidden = document.getElementById(hiddenField);
        hidden.value = Value
    }
    Row.innerHTML = formatMoney(Value)
}
function TotalPriceItemWithVatCase(id,NameElement,hiddenField = null){
    let Row = document.getElementById(id);
    let Value = SumArray(getArrayInput(NameElement))
    let XBPohIsTax = document.getElementById("XBPohIsTax")
    let VatCase = document.querySelector('input[name="XBPohTaxType"]:checked').value
    let XIPohTax = document.getElementById("XIPohTax")
    let tax= XBPohIsTax.checked ? XIPohTax.value : 0

    // if(XBPohIsTax.checked){
    //     if(VatCase === '0'){
    //         Value = Value -  VatIn(Value,tax);
    //     }
    // }
    // if (hiddenField != null){
    let hidden = document.getElementById(hiddenField);
    hidden.value = Value
    // }
    Row.innerHTML = formatMoney(Value)
}
function updateBeforeVat(){
    let Row = document.getElementById("XFPohBeforeVat");
    let RowHidden = document.getElementById("F_XFPohBeforeVat");
    let XBPohIsTax = document.getElementById("XBPohIsTax")
    let VatCase = document.querySelector('input[name="XBPohTaxType"]:checked').value
    let XIPohTax = document.getElementById("XIPohTax")
    let F_XFPohAfterBillDC = document.getElementById("F_XFPohAfterBillDC").value
    let tax= XBPohIsTax.checked ? XIPohTax.value : 0
    let Value =0;
    if(XBPohIsTax.checked){
        if(VatCase === '0'){
            Value = VatIn(F_XFPohAfterBillDC,tax);
        }else{
            Value = F_XFPohAfterBillDC;
        }
    }
    RowHidden.value = Value
    Row.innerHTML = formatMoney(Value)
}
function BillDiscount(){
    let Row = document.getElementById("XFPohAfterBillDC");
    let RowTotal = document.getElementById("F_XFPohTotal");
    let RowDiscount = document.getElementById("XFBillDiscount");
    let RowHidden = document.getElementById("F_XFPohAfterBillDC");
    let result = +RowTotal.value - +RowDiscount.value;
    Row.innerHTML = formatMoney(result)
    RowHidden.value = result
    updateBeforeVat()
    TotalVat()
    calculateCost();
}
function TotalVat(){
    let Row = document.getElementById("XFPohTotalVat");
    let RowHidden = document.getElementById("F_XFPohTotalVat");
    let F_XFPohAfterBillDC = document.getElementById("F_XFPohAfterBillDC");
    let XBPohIsTax = document.getElementById("XBPohIsTax")
    let VatCase = document.querySelector('input[name="XBPohTaxType"]:checked').value
    let XIPohTax = document.getElementById("XIPohTax")

    let tax= XBPohIsTax.checked ? XIPohTax.value : 0
    let allCost = F_XFPohAfterBillDC.value

    if(XBPohIsTax.checked){
        let vat;
        if(VatCase === '1'){
            vat =VatOut(allCost,tax)
        }else{
            vat = allCost - VatIn(allCost,tax)
        }
        Row.innerHTML=formatMoney(vat)
        RowHidden.value = vat;
    }else{
        Row.innerHTML="0.00";
        RowHidden.value = 0;
    }
}
function calculateCost(){
    let Row = document.getElementById("XFPohNet");
    let RowHidden = document.getElementById("F_XFPohNet");
    let Vat = document.getElementById("F_XFPohTotalVat").value;
    let TotalAfterDC = document.getElementById("F_XFPohAfterBillDC").value;
    let value;
    let XBPohIsTax = document.getElementById("XBPohIsTax")
    let VatCase = document.querySelector('input[name="XBPohTaxType"]:checked').value
    let RowDiscount = document.getElementById("XFBillDiscount").value;

    if(XBPohIsTax.checked){
        if(VatCase === '0'){
            value = SumArray(getArrayInput('XFPodCostTotal[]'))-RowDiscount;
        }else{
            value = +TotalAfterDC + +Vat;
        }
    }else{
        value = TotalAfterDC
    }
    Row.innerHTML =formatMoney(value)
    RowHidden.value = value

}
function handleUITax(){
    let XBPohIsTax = document.getElementById("XBPohIsTax")
    let XIPohTax = document.getElementById("XIPohTax")
    if(XBPohIsTax.checked){
        XIPohTax.readOnly = false;
    }else{
        XIPohTax.readOnly = true;
    }
}
//Helper

function selfRowTotal(price =0 ,amount = 0 ,discount = 0 ){
    return ((price * amount) - discount)
}
function SumArray(arrAmount){
    return arrAmount
        .filter((item)=>item!=='')
        .reduce((prev,curr)=>parseFloat(prev)+parseFloat(curr))
}
function VatIn(price = 0 ,vat = 0 ){
    //Total * 100 / 100+Vat
    return  +price * 100 / (100+parseInt(vat));
}
function VatOut(price = 0,vat = 0 ){
    return ( price * vat )  / 100
}
function getArrayInput(NameElement) {
    var input = document.getElementsByName(NameElement);
    let arr = []
    for (var i = 0; i < input.length; i++) {
        arr.push(input[i].value)
    }
    return arr;
}
function replaceQuotes(text){
    return  text.replace(/"/g, "&quot;");
}

function formatMoney(amount, decimalCount = 2, decimal = ".", thousands = ",") {
    try {
        decimalCount = Math.abs(decimalCount);
        decimalCount = isNaN(decimalCount) ? 2 : decimalCount;

        const negativeSign = amount < 0 ? "-" : "";

        let i = parseInt(amount = Math.abs(Number(amount) || 0).toFixed(decimalCount)).toString();
        let j = (i.length > 3) ? i.length % 3 : 0;

        return negativeSign + (j ? i.substr(0, j) + thousands : '') + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + thousands) + (decimalCount ? decimal + Math.abs(amount - i).toFixed(decimalCount).slice(2) : "");
    } catch (e) {
        console.error(e)
    }
};
//Form

function checkValue(arrVal,responseText){
    const itemFillter = arrVal.filter((item) => item.trim().length === 0)
    if (itemFillter.length > 0) {
        swal(responseText, responseText, "warning")
        return false
    } else {
        return true;
    }
}

function isNumberKey(evt){
    var charCode = (evt.which) ? evt.which : evt.keyCode;
    console.log(charCode)

    if ((charCode > 31 && (charCode < 46 || charCode > 57)) )
        return false;
    return true;
}
function isNumberKeyNoDot(evt){
    var charCode = (evt.which) ? evt.which : evt.keyCode;
    if ((charCode > 31 && (charCode < 48 || charCode > 57)) )
        return false;
    return true;
}


function plus_minus_ofPercent(defaltValue, percent = 10) {
    let arr =[];
    for (let i = 0; i < defaltValue.length; i++) {
        let percentage = (defaltValue[i] * 10) / 100
        let plus = parseInt(+defaltValue[i] + percentage)
        let minus = parseInt(+defaltValue[i] - percentage)
        arr.push({
            plus,
            minus,
            defaultValue: defaltValue[i]
        })
    }
    return arr;
}

function validateForm() {
    let ArrayPercent = plus_minus_ofPercent(getArrayInput("XIGrdQtyPo[]"))
    let ArrayReceive = getArrayInput("XIPodQty[]")
    let ArrayName = getArrayInput('XVPodName[]');
    let isPass = true;
    for (let i = 0; i < ArrayPercent.length; i++) {
        console.log(ArrayReceive[i])
        if (+ArrayReceive[i] >= ArrayPercent[i].minus && +ArrayReceive[i] <= ArrayPercent[i].plus) {

        } else {
            isPass = false;
            swal(`วัสดุ ${ArrayName[i]} `, `กรุณากรอกจำนวนรับเข้า ระหว่าง ${ArrayPercent[i].minus} - ${ArrayPercent[i].plus}`, "warning")
            break;
        }
    }
    if (isPass) {
        return true;
    }
    return false;
}
