$(document).ready(function () {
    let index = 0;
    let xvpdtcode,xvpdtname;
    $('#datepicker').datepicker({
        uiLibrary: 'bootstrap4',
        format: 'dd-mm-yyyy'
    });
    $('#datepicker1').datepicker({
        uiLibrary: 'bootstrap4',
        format: 'dd-mm-yyyy'
    });

    var SelectSize2 = $('#SelectedTempSize').select2({
        placeholder: "เลือก Size",
        theme: 'bootstrap4',
    });
    var SelectMasterItems = $('#SelectMasterItems').select2({
        placeholder: "เลือกสินค้า",
        theme: 'bootstrap4',
    });
    $('#SelectMasterItems').on('select2:select', function (e) {
        var {id,text} = (e.params.data);
        xvpdtcode = id;
        xvpdtname = text;
        let dataSize = JSON.parse(e.params.data?.element?.attributes[1]?.nodeValue)  ?? [];
        let dataMasterItem = JSON.parse(e.params.data?.element?.attributes[2]?.nodeValue)  ?? [];
        for (const [key, value] of Object.entries(dataMasterItem)) {
            const element = document.getElementById(`${key}`);
            if(element){
                if(element.tagName ==="DIV" ){
                    element.innerHTML = value

                }else if(element.tagName ==="INPUT" || element.tagName ==="TEXTAREA") {
                    element.value = value

                }
            }
        }
        let selectSize = document.getElementById('SelectedTempSize');
        const parent = document.getElementById("Control")

        let dtItems = parent.getElementsByClassName("dtItems");
        let dtSubItems = parent.getElementsByClassName("dtSubItems");
        while (dtItems.length > 0) {
            dtItems[0].parentNode.removeChild(dtItems[0]);
        }
        while (dtSubItems.length > 0) {
            dtSubItems[0].parentNode.removeChild(dtSubItems[0]);
        }

        selectSize.innerHTML = ""

        for(let i = 0 ; i < dataSize.length;i++){
            let opt = document.createElement('option');
            const size = dataSize[i].XVPszName;
            opt.value = size;
            opt.innerHTML = size;
            selectSize.appendChild(opt);
        }
    });
    window.TriggerChange = function(oldArr){
        SelectMasterItems.val(oldArr).trigger("change");
        xvpdtname = $('#SelectMasterItems option:selected').text();
    }
    window.TriggerChangeSize = function(oldArr){
        SelectSize2.val(oldArr).trigger("change");
    }
    window.updateIndex = function (cntItem){
        index = cntItem
    }
    $('#SelectedTempSize').on('select2:select', function (e) {
        let xvpdtcode = document.getElementById('SelectMasterItems').value;
        var {id,text} = (e.params.data);
        createProduct(xvpdtcode,xvpdtname,id,index)
        index= index+1;
    });
})
async function createProduct(id,text,sizeType,index) {
    let BomDefault = await getBom(id,sizeType)
    let parentID = `${sizeType}`
    let childID = `group-of-rows-${parentID}`
    let childRow = renderChildRow(BomDefault.bom,index,childID)
    let str = text.replace(/ /g, '');
    str = replaceQuotesText(str);
    let txt = str.split(":");
    const Control = document.getElementById("Control")
    Control.insertAdjacentHTML('afterbegin',
                    `<tr id="${parentID}" class="dtItems"  style="cursor: pointer;">
                                    <input type="hidden" name="XVPszName[${index}][]" value="${sizeType}">
                                    <th scope="row" onclick="handleChild('${childID}')" style="display: none">${txt[0]}</th>
                                    <th scope="row" onclick="handleChild('${childID}')" style="display: none">${txt[1]}</th>
                                    <th onclick="handleChild('${childID}')">
                                    ${sizeType}
                                    </th>
                                    <td>
                                        <input type="text" class="form-control text-right" name="XIOrdQty[${index}][]"
                                        required
                                        onchange="updateQtyUse('${childID}','${index}')"
                                        onkeypress='return isNumberKeyNoDot(event)' value="1"/>
                                    </td>

                                    <td class="text-center">
                                        <button type="button" class="btn btn-success btn-circle " onclick="handleChild('${childID}')"><i class="fas fa-vest-patches"></i></button>
                                        <button type="button" class="btn btn-danger btn-circle btn-sm" onclick="removeRow('${parentID}','${childID}')">X</button>
                                    </td>
                                    <input type="hidden" name="xvpdtcode[${index}][]" value="${id}">
                                </tr>
                                <tr id="${childID}" class="dtSubItems"  style="display: none">
                                    <td colspan="4">
                                        <table class="table table-bordered ">
                                            <thead>
                                            <tr>
                                                <th scope="col" width="10%">รหัส</th>
                                                <th scope="col">วัสดุ</th>
                                                <th scope="col" width="10%">หน่วยนับ</th>
                                                <th scope="col" width="10%">จำนวนต่อหน่วย</th>
                                                <th scope="col" width="10%">จำนวนทั้งหมดที่ใช้</th>
                                            </tr>
                                            </thead>
                                            ${childRow}
                                        </table>
                                    </td>
                                </tr>
`)
    updateTotalSumQty()
}
function updateQtyUse(childID,index){
    let QtyOrder = document.getElementsByName(`XIOrdQty[${index}][]`)[0].value
    let input = document.getElementsByName(`XIBomQty[${index}][]`);
    let output = document.getElementsByName(`XIOrmFactor[${index}][]`);
    for (let i = 0; i < input.length; i++) {
        output[i].value = QtyOrder * input[i].value;
    }
    updateTotalSumQty()
}
function updateTotalSumQty(){
    let totalItem = document.getElementsByClassName(`dtItems`)
    let sum = 0 ;
    for(let i =0 ; i < totalItem.length; i++){
        sum = sum + parseInt(document.getElementsByName(`XIOrdQty[${i}][]`)[0].value)
    }
    document.getElementById(`TotalAmount`).innerHTML=sum
}
function handleChild(childID){
    let child = document.getElementById(childID);
    if(child.style.display ==="none"){
        child.style.display = ""
    }else{
        child.style.display = "none"
    }
}
function renderChildRow(arrBom,index,childID){
    let arr = "";
    for(let i= 0 ; i < arrBom.length;i++){
        arr+=`<tr class="table-warning">
                                    <input type="hidden" name="xvmatcode[${index}][]" value="${arrBom[i].xvmatcode}">
                                    <input type="hidden" name="xvuntcode[${index}][]" value="${arrBom[i].xvuntcode}">

                                        <td>${arrBom[i].xvmatcode} </td>
                                        <td>${arrBom[i].xvmatname}</td>
                                        <td>${arrBom[i].xvuntname}</td>
                                        <td>
                                            <input type="text" class="form-control text-right" name="XIBomQty[${index}][]"
                                            required
                                            onchange="updateQtyUse('${childID}','${index}')"
                                            onkeypress='return isNumberKeyNoDot(event)'  min="1" value="${arrBom[i].XIBomQty}"/>
                                        </td>
                                        <td id="Total_${childID}">
                                            <input type="text" class="form-control text-right" name="XIOrmFactor[${index}][]"
                                                readonly
                                                onkeypress='return isNumberKeyNoDot(event)'   value="${arrBom[i].XIBomQty}"/>
                                        </td>
                                    </tr>`
    }
    return arr;
}

async function getBom(xvpdtcode,XVPszName){
    const AppUrl = document.getElementById('urlGlobal').value;
    const response = await  fetch(`${AppUrl}/bomSize/recepie/${xvpdtcode}/${XVPszName}`)
    return response.json();
}

function removeRow(id,childID){
    document.getElementById(id).remove();
    document.getElementById(childID).remove();
    updateCurrentDT()
}
function updateCurrentDT(){
    var oldList = document.getElementsByClassName("dtItems")
    let oldArr = [];
    for(let i = 0 ; i < oldList.length; i++){
        oldArr.push(oldList[i].id)
    }
    TriggerChangeSize(oldArr)
}
async function validateForm() {
    const XIOrdBalance = getArrayInput('XIOrdBalance[]');
    const XIGidQty = getArrayInput('XIGidQty[]');
    let state = true;
    for(let i = 0 ; i<XIOrdBalance.length ; i++){
        const CurrentBlanace = XIOrdBalance[i];
        const CurrentGidQty = XIGidQty[i];
        if(+CurrentGidQty > +CurrentBlanace){
            state = false;
            break;
        }
    }
    if(state){
        document.getElementById("Form_Submit").submit();
    }else{
        let resp = swal({
            title: "จำนวนคงเหลือ น้อยกว่าจำนวนที่เบิก",
            text: "ยืนยันหรือไม่ ?",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        })
        let isOk = await resp
        if(!!isOk){
            document.getElementById("Form_Submit").submit();
        }
    }
}
function getArrayInput(NameElement) {
    var input = document.getElementsByName(NameElement);
    let arr = []
    for (var i = 0; i < input.length; i++) {
        arr.push(input[i].value)
    }
    return arr;
}
function isNumberKeyNoDot(evt){
    var charCode = (evt.which) ? evt.which : evt.keyCode;
    if ((charCode > 31 && (charCode < 48 || charCode > 57)) )
        return false;
    return true;
}
