const miniMumRow = 30;
const HeaderName = "201 รายงานการสั่งซื้อแยกตามผู้จำหน่าย";
const column = 6;

function countLineSpace(text) {
    return Math.floor((text.length / 20)) * 10;
}

function renderPdf(result,filter) {
    let header = SectionHeader(filter);
    let ListItems = ListItem(result);
    let SubHeaderX = SubHeader();

    var dd = {
        pageSize: 'A4',
        // pageOrientation: 'landscape',
        // pageMargins: [20, 20],
        pageMargins: [20, 103, 20, 20],
        header: function (currentPage, pageCount, pageSize) {
            return {
                stack: [...header,...SubHeaderX],
                margin: [20, 15, 20, 0]
            }
        },
        content: [
            ...ListItems,
        ],
        defaultStyle: {
            font: "Sarabun",
            fontSize: 7,

        }
    }
    pdfMake.createPdf(dd).open()
}

// ซ้าย บน ขวา ล่าง

function SectionHeader(filter) {

    let DateStart,DateEnd,CstNameStart,CstNameEnd
    if(!!filter.isAllTime){
         DateStart = "ทั้งหมด"
         DateEnd = "ทั้งหมด"
    }else{
         DateStart = convertDateToLocale(filter.DateStart)
         DateEnd = convertDateToLocale(filter.DateEnd)
    }
    if(!!filter.isAllSpl){
         CstNameStart = "ทั้งหมด"
         CstNameEnd = "ทั้งหมด"
    }else{
         CstNameStart = (filter.SplStart)
         CstNameEnd = (filter.SplEnd)
    }
    return [
        {
            text: HeaderName,
            alignment: 'center',
            fontSize: 11,
            bold: true,

        },
        {
            text: `จากวันที่ ${DateStart}  ถึงวันที่ ${DateEnd}`,
            alignment: 'center',
            fontSize: 10,
            bold: false,
        },
        {
            text: `จากผู้จำหน่าย ${CstNameStart}\nถึง ${CstNameEnd}`,
            alignment: 'center',
            fontSize: 10,
            bold: false,
        },
    ]
}

function SubHeader() {
    return [
        {
            table: {
                widths: [80, 60, '*', 70],
                body: [
                    [
                        {text: 'ผู้จำหน่าย', fontSize: 9, alignment: 'left', rowSpan: 2, border: [true, true,true,true]},
                        {text: 'วันที่', fontSize: 9, alignment: 'left', rowSpan: 2, border: [true, true,true,true]},
                        {text: 'เลขที่ใบสั่งซื้อ', fontSize: 9, alignment: 'left', border: [true, true,true,false]},
                        {text: 'ยอดซื้อ', fontSize: 9, alignment: 'right', border: [true, true,true,false]},
                    ],
                    [
                        {},
                        {},
                        {text: '\tวัสดุ', fontSize: 9, alignment: 'left',preserveLeadingSpaces: true, border: [true, false,true,true]},
                        {text: 'ยอด', fontSize: 9, alignment: 'left', border: [true, false,true,true]},

                    ],
                ]
            },
            layout: {
                fillColor: function (rowIndex, node, columnIndex) {
                    return (rowIndex === 0 || rowIndex === 1) ? '#CCCCCC' : null;
                },
                hLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 1 : 1;
                },
                vLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 1 : 1;
                },
                hLineColor: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 'black' : 'gray';
                },
                vLineColor: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 'black' : 'gray';
                },
            }
        },

    ]
}
function ListItem(result) {
    let arrayItems = [] ;
    for(let i = 0 ; i < result.length ; i++){
        let {Items,SumCost} = renderItem(result[i]);
        if(Items.length >0){
            Items = renderSumRow(Items,SumCost);
        }
        arrayItems = [...arrayItems,...Items]
    }
    return [
        {
            table: {
                widths: [80, 60, '*', 70],
                body: [
                    ...arrayItems,
                ]
            },
        },
    ]
}

function renderItem({XVSplCode,XVSplName,OrderHD}) {
    let Item = []
    let SumCost = 0;
    for (let i = 0; i < OrderHD.length; i++) {
        const {XVPohDocNo,XDPohDocDate,CostTotal,OrderDT} = OrderHD[i];
        SumCost = SumCost+parseFloat(CostTotal);
        const oldValue = OrderHD[i-1] ?? {XVPohDocNo :null , XDPohDocDate:null};
        let DateDisplay,NameDisplay;
        if(XDPohDocDate == oldValue.XDPohDocDate){
            DateDisplay=""
            NameDisplay = '';
        }else{
            DateDisplay = convertDateToLocale(XDPohDocDate)
            NameDisplay = `${XVSplCode+" "+XVSplName}`
        }
        const GlobalHeader = i == OrderHD.length-1 ? {border: [true, false,true,false]} : {border: [true, false,true,false]};
        Item.push([
            {text: NameDisplay, fontSize: 8, alignment: 'left',rowSpan:OrderDT.length+1,...GlobalHeader},
            {text: DateDisplay, fontSize: 8, alignment: 'center',rowSpan:OrderDT.length+1,...GlobalHeader},
            {text: XVPohDocNo, fontSize: 8, alignment: 'left',border: [true, false,true,true],...GlobalHeader},
            {text: formatMoney(CostTotal), fontSize: 8, alignment: 'right',border: [true, false,true,true],...GlobalHeader},
        ],)
        for (let j = 0; j < OrderDT.length; j++) {
            const DetailBorder = (i == OrderHD.length-1 && j == OrderDT.length-1) ? {border: [true, false,true,false]} : {border: [true, false,true,false]}

            const {XFPodCostTotal,xvmatcode,XVPodName} = OrderDT[j]
            Item.push([
                {},
                {},
                {text: `\t${xvmatcode} ${XVPodName}`, fontSize: 8, alignment: 'left',preserveLeadingSpaces: true,...DetailBorder},
                {text: formatMoney(XFPodCostTotal), fontSize: 8, alignment: 'left',...DetailBorder},
            ],)
        }

    }
    return {Items: Item,SumCost }
}
function renderSumRow(Items,SumCost){
    Items.push([
        {text: "รวม", fontSize: 8, alignment: 'center',colSpan:3},
        {},
        {},
        {text: formatMoney(SumCost), fontSize: 8, alignment: 'right'},
    ],)
    return Items;
}
//Utility


function formatMoney(amount, decimalCount = 2, decimal = ".", thousands = ",") {
    try {
        decimalCount = Math.abs(decimalCount);
        decimalCount = isNaN(decimalCount) ? 2 : decimalCount;

        const negativeSign = amount < 0 ? "-" : "";

        let i = parseInt(amount = Math.abs(Number(amount) || 0).toFixed(decimalCount)).toString();
        let j = (i.length > 3) ? i.length % 3 : 0;

        return negativeSign + (j ? i.substr(0, j) + thousands : '') + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + thousands) + (decimalCount ? decimal + Math.abs(amount - i).toFixed(decimalCount).slice(2) : "");
    } catch (e) {
        console.error(e)
    }
};

function convertDateToLocale(date) {
    return new Date(date).toLocaleDateString('th')
}
