const miniMumRow = 30;
const HeaderName = "304 รายงานความเคลื่อนไหวของวัสดุ";
const column = 6;

function countLineSpace(text) {
    return Math.floor((text.length / 20)) * 10;
}

function renderPdf(result,filter) {
    let header = SectionHeader(filter);
    let ListItems = ListItem(result);
    let SubHeaderX = SubHeader();

    var dd = {
        pageSize: 'A4',
        // pageMargins: [20, 20],
        pageMargins: [20, 86, 20, 20],
        header: function (currentPage, pageCount, pageSize) {
            return {
                stack: [...header,...SubHeaderX],
                margin: [20, 15, 20, 0]
            }
        },
        content: [
            ...ListItems,
        ],
        defaultStyle: {
            font: "Sarabun",
            fontSize: 7,

        }
    }
    pdfMake.createPdf(dd).open()
}

// ซ้าย บน ขวา ล่าง

function SectionHeader(filter) {

    let DateStart,DateEnd,CstNameStart,CstNameEnd
    if(!!filter.isAllTime){
         DateStart = "ทั้งหมด"
         DateEnd = "ทั้งหมด"
    }else{
         DateStart = convertDateToLocale(filter.DateStart)
         DateEnd = convertDateToLocale(filter.DateEnd)
    }
    if(!!filter.isAllMat){
         CstNameStart = "ทั้งหมด"
         CstNameEnd = "ทั้งหมด"
    }else{
         CstNameStart = (filter.MatStart)
         CstNameEnd = (filter.MatEnd)
    }
    return [
        {
            text: HeaderName,
            alignment: 'center',
            fontSize: 11,
            bold: true,

        },
        {
            text: `จากวันที่ ${DateStart}  ถึงวันที่ ${DateEnd}`,
            alignment: 'center',
            fontSize: 10,
            bold: false,
        },
        {
            text: `จากวัสดุ ${CstNameStart}\nถึง ${CstNameEnd}`,
            alignment: 'center',
            fontSize: 10,
            bold: false,
        },
    ]
}

function SubHeader() {
    return [
        {
            table: {
                widths: [140, 60, 70, 70, 80, 80],
                body: [
                    [
                        {text: 'วัสดุ', fontSize: 9, alignment: 'left',   border: [true, true,true,true]},
                        {text: 'วันที่', fontSize: 9, alignment: 'left',   border: [true, true,true,true]},
                        {text: 'ประเภท', fontSize: 9, alignment: 'left',   border: [true, true,true,true]},
                        {text: 'เอกสาร', fontSize: 9, alignment: 'left', border: [true, true,true,true]},
                        {text: 'จำนวน', fontSize: 9, alignment: 'left',  border: [true, true,true,true]},
                        {text: 'คงเหลือ', fontSize: 9, alignment: 'left',  border: [true, true,true,true]},
                    ],
                ]
            },

            layout: {
                fillColor: function (rowIndex, node, columnIndex) {
                    return (rowIndex === 0 ) ? '#CCCCCC' : null;
                },
                hLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 1 : 1;
                },
                vLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 1 : 1;
                },
                hLineColor: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 'black' : 'gray';
                },
                vLineColor: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 'black' : 'gray';
                },
            }
        },

    ]
}
function ListItem(result) {
    let arrayItems = [] ;
    for(let i = 0 ; i < result.length ; i++){
        let {Items} = renderItem(result[i]);
        // if(Items.length >0){
        //     Items = renderSumRow(Items);
        // }
        arrayItems = [...arrayItems,...Items]
    }
    return [
        {
            table: {
                widths: [140, 60, 70, 70, 80, 80],
                body: [
                    ...arrayItems,
                ]
            },
        },

    ]
}
function renderItem({xvmatcode,xvmatname,OrderHD}) {
    let Item = []
    let tempStockQty = 0;
    for (let i = 0; i < OrderHD.length; i++) {
        const {xvstkdocno,xdstkdate,xistkqty ,xvstktype} = OrderHD[i];
        const oldValue = OrderHD[i-1] ?? {xvstkdocno :null , xdstkdate:null};
        let DateDisplay ;
        if(xdstkdate == oldValue.xdstkdate){
            DateDisplay=""
        }else{
            DateDisplay = convertDateToLocale(xdstkdate)
        }
        let NameDisplay = i == 0 ? `${xvmatcode+" "+xvmatname}`:'';
        const DetailBorder = (i == OrderHD.length-1) ? {border: [true, false,true,true]} : {border: [true, false,true,false]}
        const GlobalHeader = i == OrderHD.length-1 ? {border: [true, false,true,true]} : {border: [true, false,true,false]};

        tempStockQty = calculateStockByCode(xvstktype,tempStockQty,xistkqty);
        if(i == 0 ){
            Item.push([
                {text: NameDisplay, fontSize: 8, alignment: 'left',rowSpan:OrderHD.length},
                {text: DateDisplay, fontSize: 8, alignment: 'center',...GlobalHeader},
                {text: getTextStockCardByCode(xvstktype), fontSize: 8, alignment: 'left',...DetailBorder},
                {text: xvstkdocno, fontSize: 8, alignment: 'left',...DetailBorder},
                {text: formatMoney(xistkqty,0,''), fontSize: 8, alignment: 'right',...DetailBorder},
                {text: formatMoney(tempStockQty,0,''), fontSize: 8, alignment: 'right',...DetailBorder},
            ],)
        }else{
            Item.push([
                {},
                {text: DateDisplay, fontSize: 8, alignment: 'center',...GlobalHeader},
                {text: getTextStockCardByCode(xvstktype), fontSize: 8, alignment: 'left',...DetailBorder},
                {text: xvstkdocno, fontSize: 8, alignment: 'left',...DetailBorder},
                {text: formatMoney(xistkqty,0,''), fontSize: 8, alignment: 'right',...DetailBorder},
                {text: formatMoney(tempStockQty,0,''), fontSize: 8, alignment: 'right',...DetailBorder},
            ],)
        }

    }
    return {Items: Item }
}
function renderSumRow(Items){
    Items.push([
        {},
        {},
        {},
        {},
        {},
        {},
    ],)
    return Items;
}
//Utility
function getTextStockCardByCode(code)
{
    switch (code) {
        case '0' :
            return "ยอดยกมา";
            break;
        case '1' :
            return "รับเข้า";
            break;
        case '2' :
            return "เบิกออก";
            break;
        case '3' :
            return "ขาย";
            break;
        case '4' :
            return "คืน";
        case '5' :
            return "ปรับปรุง ( เพิ่ม )";
            break;
        case '6' :
            return "ปรับปรุง ( ลบ )";
            break;
        default :
            return " ";
            break;
    }
}
function calculateStockByCode(code,tempQty,qtystk)
{
    switch (code) {
        case '1' :
        case '5' :
            return tempQty + parseFloat(qtystk)
        case '2' :
        case '6' :
            return tempQty - parseFloat(qtystk)
        default :
            return tempQty;
    }
}

function formatMoney(amount, decimalCount = 2, decimal = ".", thousands = ",") {
    try {
        decimalCount = Math.abs(decimalCount);
        decimalCount = isNaN(decimalCount) ? 2 : decimalCount;

        const negativeSign = amount < 0 ? "-" : "";

        let i = parseInt(amount = Math.abs(Number(amount) || 0).toFixed(decimalCount)).toString();
        let j = (i.length > 3) ? i.length % 3 : 0;

        return negativeSign + (j ? i.substr(0, j) + thousands : '') + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + thousands) + (decimalCount ? decimal + Math.abs(amount - i).toFixed(decimalCount).slice(2) : "");
    } catch (e) {
        console.error(e)
    }
};

function convertDateToLocale(date) {
    return new Date(date).toLocaleDateString('th')
}
