const miniMumRow = 30;
const HeaderName = "402 รายงานการผลิตสินค้าแยกตามสินค้า";
const column = 6;

function countLineSpace(text) {
    return Math.floor((text.length / 20)) * 10;
}

function renderPdf(result,filter) {
    let header = SectionHeader(filter);
    let ListItems = ListItem(result);
    let SubHeaderX = SubHeader();

    var dd = {
        pageSize: 'A4',
        // pageMargins: [20, 20],
        pageMargins: [20, 86, 20, 20],
        header: function (currentPage, pageCount, pageSize) {
            return {
                stack: [...header,...SubHeaderX],
                margin: [20, 15, 20, 0]
            }
        },
        content: [
            ...ListItems,
        ],
        defaultStyle: {
            font: "Sarabun",
            fontSize: 7,

        }
    }
    pdfMake.createPdf(dd).open()
}

// ซ้าย บน ขวา ล่าง

function SectionHeader(filter) {

    let DateStart,DateEnd,CstNameStart,CstNameEnd
    if(!!filter.isAllTime){
         DateStart = "ทั้งหมด"
         DateEnd = "ทั้งหมด"
    }else{
         DateStart = convertDateToLocale(filter.DateStart)
         DateEnd = convertDateToLocale(filter.DateEnd)
    }
    if(!!filter.isAllMst){
         CstNameStart = "ทั้งหมด"
         CstNameEnd = "ทั้งหมด"
    }else{
         CstNameStart = (filter.MstItemStart)
         CstNameEnd = (filter.MstItemEnd)
    }
    return [
        {
            text: HeaderName,
            alignment: 'center',
            fontSize: 11,
            bold: true,

        },
        {
            text: `จากวันที่ ${DateStart}  ถึงวันที่ ${DateEnd}`,
            alignment: 'center',
            fontSize: 10,
            bold: false,
        },
        {
            text: `จากสินค้า ${CstNameStart}\nถึง ${CstNameEnd}`,
            alignment: 'center',
            fontSize: 10,
            bold: false,
        },
    ]
}

function SubHeader() {
    return [
        {
            table: {
                widths: [80, 60, '*', '*', 80, 80],
                body: [
                    [
                        {text: 'สินค้า', fontSize: 9, alignment: 'left',   border: [true, true,true,true]},
                        {text: 'วันที่', fontSize: 9, alignment: 'left',   border: [true, true,true,true]},
                        {text: 'เลขที่ใบสั่งผลิต', fontSize: 9, alignment: 'left', border: [true, true,true,true]},
                        {text: 'เลขที่ใบรับสินค้า', fontSize: 9, alignment: 'left',  border: [true, true,true,true]},
                        {text: 'จำนวนสั่ง', fontSize: 9, alignment: 'left',  border: [true, true,true,true]},
                        {text: 'จำนวนผลิต', fontSize: 9, alignment: 'left',  border: [true, true,true,true]},
                    ],
                ]
            },

            layout: {
                fillColor: function (rowIndex, node, columnIndex) {
                    return (rowIndex === 0 ) ? '#CCCCCC' : null;
                },
                hLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 1 : 1;
                },
                vLineWidth: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 1 : 1;
                },
                hLineColor: function (i, node) {
                    return (i === 0 || i === node.table.body.length) ? 'black' : 'gray';
                },
                vLineColor: function (i, node) {
                    return (i === 0 || i === node.table.widths.length) ? 'black' : 'gray';
                },
            }
        },

    ]
}
function ListItem(result) {
    let arrayItems = [] ;
    for(let i = 0 ; i < result.length ; i++){
        let {Items,SumFRQty,SumOrderQty} = renderItem(result[i]);
        if(Items.length >0){
            Items = renderSumRow(Items,SumOrderQty,SumFRQty);
        }
        arrayItems = [...arrayItems,...Items]
    }
    return [
        {
            table: {
                widths: [80, 60, '*', '*', 80, 80],
                body: [
                    ...arrayItems,
                ]
            },

        },

    ]
}
function renderSumRow(Items,SumOrder,SumFR){
    Items.push([
        {text: "รวม", fontSize: 8, alignment: 'center',colSpan:4,border: [true, true,false,true]},
        {},
        {},
        {},
        {text: formatMoney(SumOrder), fontSize: 8, alignment: 'right',border: [false, true,false,true]},
        {text: formatMoney(SumFR), fontSize: 8, alignment: 'right',border: [false, true,true,true]},
    ],)
    return Items;
}
function renderItem({xvpdtcode,xvpdtname,OrderHD}) {
    let Item = []
    let SumOrderQty = 0;
    let SumFRQty = 0;
    let NameDisplay =`${xvpdtcode+" "+xvpdtname}`;
    if(OrderHD.length>0){
        Item.push([
            {text: NameDisplay, fontSize: 8,colSpan:6, alignment: 'left',border: [true, false,true,false]},
            {},
            {},
            {},
            {},
            {},
        ],)
    }
    for (let i = 0; i < OrderHD.length; i++) {
        const {XVOrhDocNo,XDOrhDocDate,SumOrder,XVFrhDocNo,SumFR} = OrderHD[i];
        SumOrderQty = SumOrderQty+ +SumOrder;
        SumFRQty = SumFRQty+ +SumFR;
        const oldValue = OrderHD[i-1] ?? {XVOrhDocNo :null , XDOrhDocDate:null};
        let DateDisplay;
        if(XDOrhDocDate == oldValue.XDOrhDocDate){
            DateDisplay=""
        }else{
            DateDisplay = convertDateToLocale(XDOrhDocDate)
        }

        // const GlobalHeader = i == OrderHD.length-1 ? {border: [true, false,true,false]} : {border: [true, false,true,false]};
        Item.push([
            {text: "", fontSize: 8, alignment: 'left',border: [true, false,false,false]},
            {text: DateDisplay, fontSize: 8, alignment: 'center',border: [false, false,false,false]},
            {text: XVOrhDocNo, fontSize: 8, alignment: 'left',border: [false, false,false,false]},
            {text: XVFrhDocNo, fontSize: 8, alignment: 'left',border: [false, false,false,false]},
            {text: formatMoney(SumOrder), fontSize: 8, alignment: 'right',border: [false, false,false,false]},
            {text: formatMoney(SumFR), fontSize: 8, alignment: 'right',border: [false, false,true,false]},
        ],)
    }
    return {Items:Item,SumOrderQty,SumFRQty}
}

//Utility


function formatMoney(amount, decimalCount = 2, decimal = ".", thousands = ",") {
    try {
        decimalCount = Math.abs(decimalCount);
        decimalCount = isNaN(decimalCount) ? 2 : decimalCount;

        const negativeSign = amount < 0 ? "-" : "";

        let i = parseInt(amount = Math.abs(Number(amount) || 0).toFixed(decimalCount)).toString();
        let j = (i.length > 3) ? i.length % 3 : 0;

        return negativeSign + (j ? i.substr(0, j) + thousands : '') + i.substr(j).replace(/(\d{3})(?=\d)/g, "$1" + thousands) + (decimalCount ? decimal + Math.abs(amount - i).toFixed(decimalCount).slice(2) : "");
    } catch (e) {
        console.error(e)
    }
};

function convertDateToLocale(date) {
    return new Date(date).toLocaleDateString('th')
}
