@extends('layouts.master')
@section('header')
    <link href="{{asset('css/gijgo.min.css')}}" rel="stylesheet" type="text/css"/>
    <link href="{{asset('css/select2.min.css')}}" rel="stylesheet"/>
    <link rel="stylesheet"
          href="{{asset('css/select2-bootstrap4.min.css')}}">
@endsection
<style>
    div.sticky {
        position: sticky;
        top: 0;
        background-color: #ffffff;
        padding-top: 8px;
        z-index: 100;
    }

    form.noStyle {
        margin: 0;
    }

    .btn-circle.btn-sm {
        width: 30px;
        height: 30px;
        padding: 6px 0px;
        border-radius: 15px;
        font-size: 8px;
        text-align: center;
    }

    .form-control {
        display: inline-block !important;
    }

    tr:hover {
        background-color: #f5f5f5;
    }


</style>
@section('content')

    <form action="{{route('fr.store')}}" method="POST" id="Form_Submit"
          class="noStyle"
          onsubmit="return validateForm()">
        @csrf
        <div class="card ">
            <div class="card-body">
                <div class="sticky">
                    <div class="row ">
                        <div class="col-3 ">
                            <h5>ฟอร์มเพิ่มข้อมูลใบรับสินค้า</h5>
                        </div>
                        <div class="col text-right">
                            <label for="" class="mr-2 fontsi">สถานะเอกสาร : {{getDocStatusByCode(1)}}</label>

                            <a href="{{route('fr.index')}}" class="btn btn-danger"><i
                                    class="fas fa-long-arrow-alt-left fa-lg"></i> <span>กลับ</span></a>
                                    <button type="submit" class="btn btn-success">บันทึก</button>
                        </div>

                    </div>
                    <hr>
                </div>
                <h5>ข้อมูลเอกสาร</h5>

                <div class="row border">

                    <div class="col border-right ">

                        @component('FR.components.hd',['oldHD'=>$hd,'xvpdtcode'=>$xvpdtcode])
                        @endcomponent
                    </div>
                    <div class="col border-right ">

                        @component('FR.components.rmk',['XVFrhDocRmk'=>$hd->XVFrhDocRmk??''])
                        @endcomponent
                    </div>

                </div>
                <div class="row border">
                    <div class="col border-right ">

                        @component('FR.components.dt',['oldDT'=>$dt])
                        @endcomponent

                    </div>

                </div>
            </div>
        </div>
        </div>
    </form>
    <input type="hidden" value="{{$xvpdtcode}}" id="oldSelectedPdtCode">
@endsection
<script src="{{asset('js/helper.js')}}"></script>
<script src="{{asset('js/jquery-3.5.1.min.js')}}"></script>
<script src="{{asset('js/gijgo.min.js')}}" defer type="text/javascript"></script>
<script src="{{asset('js/select2.min.js')}}" defer></script>
<script src="{{asset('js/sweetalert.min.js')}}"></script>
<script src="{{asset('js/pages/Fr/form.js')}}"></script>
<script src="{{asset('js/ThbNumber.js')}}"></script>
<script src="{{ asset('js/pdfmake.js') }}"></script>
<script src="{{asset('js/pages/Fr/pdf.js')}}"></script>
<script>
    // SelectMasterItems
</script>

<script>
    async function Swal_Ask(text, form) {
        let resp = swal({
            title: `ยืนยันการ ${text} ?`,
            text: "หากยืนยันแล้วไม่สามารถเปลี่ยนแปลงได้",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        })
        let isOk = await resp
        if (isOk) form.submit();
    }

    async function updateStatus(statusCode, text) {
        const ApproveForm = document.getElementById("updateForm");
        const eventRequest = document.getElementById("eventRequest");
        let resp = swal({
            title: `ยืนยันการ ${text} ?`,
            text: "หากยืนยันแล้วไม่สามารถเปลี่ยนแปลงได้",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        })
        let isOk = await resp
        if (isOk) {
            eventRequest.value = statusCode
            ApproveForm.submit()
        }
        ;
    }

    $(document).ready(function () {
        updateTotalSumQty();

    })
</script>

