@extends('layouts.master')
@php
    $menuperm = Illuminate\Support\Facades\Session::get('menu_perm') ?? [];
@endphp
@section('header')
    <link href="{{asset('css/gijgo.min.css')}}" rel="stylesheet" type="text/css"/>
    <link href="{{asset('css/select2.min.css')}}" rel="stylesheet"/>
    <link rel="stylesheet"
          href="{{asset('css/select2-bootstrap4.min.css')}}">
@endsection
<style>
    div.sticky {
        position: sticky;
        top: 0;
        background-color: #ffffff;
        padding-top: 8px;
        z-index: 100;
    }

    form.noStyle {
        margin: 0;
    }

    .btn-circle.btn-sm {
        width: 30px;
        height: 30px;
        padding: 6px 0px;
        border-radius: 15px;
        font-size: 8px;
        text-align: center;
    }

    .form-control {
        display: inline-block !important;
    }

    tr:hover {
        background-color: #f5f5f5;
    }


</style>
@section('content')
    <form action="{{route('fr.updateStatus')}}" method="POST" style="margin: 0"
          onkeypress="return event.keyCode != 13;"
          id="updateForm"
          onsubmit="event.preventDefault(); return Swal_Ask('{{getDocStatusByCode(3)}}',this)">
        @csrf
        <div class="col-1 text-left">
            <input type="hidden" class="form-control" name="XVFrhDocNo" value="{{$hd->XVFrhDocNo}}" readonly>
            <input type="hidden" class="form-control" id="eventRequest" name="eventRequest" value="3" readonly>
            <input type="hidden" class="form-control" id="docStatus" name="docStatus" value="{{$DocStatus}}" readonly>
        </div>
    </form>
    <form action="{{route('fr.update')}}" method="POST" id="Form_Submit"
          class="noStyle"
          onsubmit="return validateForm()">
        @csrf
        @method('PUT')
        <div class="card ">
            <div class="card-body">
                <div class="sticky">
                    <div class="row ">
                        <div class="col-3 ">
                            <h5>ฟอร์มแก้ไขข้อมูลใบรับสินค้า</h5>
                        </div>
                        
                        @if (in_array(8, $menuperm))
                            @php
                                $routeBack = 'fr.index';
                            @endphp
                        {{-- @else
                            @php
                                $routeBack = 'Approve.fr';
                            @endphp --}}
                        @endif
                        @component('Components.HandleDocStatus',['routeBack'=>$routeBack,'DocStatus'=>$DocStatus])
                            <div class="col-1 text-left">
                                <a href="#" type="button" class="btn btn-info"
                                   onclick="renderPdf('{{route('fr.pdf',['docNo'=>$hd->XVFrhDocNo])}}')"><i class="far fa-file-pdf"></i> PDF</a>
                                <input type="hidden" id="url" value="{{url('')}}">
                            </div>
                        @endcomponent

                    </div>
                    <hr>
                </div>
                <h5>ข้อมูลเอกสาร</h5>

                <div class="row border">

                    <div class="col border-right ">

                        @component('FR.components.hd',['oldHD'=>$hd,'xvpdtcode'=>$xvpdtcode])
                        @endcomponent
                    </div>
                    <div class="col border-right ">

                        @component('FR.components.rmk',['XVFrhDocRmk'=>$hd->XVFrhDocRmk??''])
                        @endcomponent
                    </div>

                </div>
                <div class="row border">
                    <div class="col border-right ">

                        @component('FR.components.dt',['oldDT'=>$dt,'DocStatus'=>$DocStatus])
                        @endcomponent

                    </div>

                </div>
            </div>
        </div>
        </div>
    </form>
    <input type="hidden" value="{{$xvpdtcode}}" id="oldSelectedPdtCode">
    <input type="hidden" name="msg" value="{{session()->get('msg')}}">

@endsection
<script src="{{asset('js/helper.js')}}"></script>
<script src="{{asset('js/jquery-3.5.1.min.js')}}"></script>
<script src="{{asset('js/gijgo.min.js')}}" defer type="text/javascript"></script>
<script src="{{asset('js/select2.min.js')}}" defer></script>
<script src="{{asset('js/sweetalert.min.js')}}"></script>
<script src="{{asset('js/pages/Fr/form.js')}}"></script>
<script src="{{asset('js/ThbNumber.js')}}"></script>
<script src="{{ asset('js/pdfmake.js') }}"></script>
<script src="{{asset('js/pages/Fr/pdf.js')}}"></script>



<script>
    // SelectMasterItems
</script>

<script>
    async function Swal_Ask(text, form) {
        let resp = swal({
            title: `ยืนยันการ ${text} ?`,
            text: "หากยืนยันแล้วไม่สามารถเปลี่ยนแปลงได้",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        })
        let isOk = await resp
        if (isOk) form.submit();
    }

    async function updateStatus(statusCode, text) {
        const ApproveForm = document.getElementById("updateForm");
        const eventRequest = document.getElementById("eventRequest");
        let resp = swal({
            title: `ยืนยันการ ${text} ?`,
            text: "หากยืนยันแล้วไม่สามารถเปลี่ยนแปลงได้",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        })
        let isOk = await resp
        if (isOk) {
            eventRequest.value = statusCode
            ApproveForm.submit()
        }
        ;
    }

    $(document).ready(function () {
        if ($('input[name="msg"]').val() == 'unusagegi') {
            swal("ไม่พบ GI", "กรุณาทำการเบิกวัสดุก่อนการรับสินค้า", "warning");
        }
        if ($('input[name="msg"]').val() == 'IsNotBalanced') {
            swal("เกิดข้อผิดพลาด", "กรุณาทำรายการยอดยกมาสินค้าของเดือนที่แล้วก่อนทำการอนุมัติ", "warning");
        }

        updateTotalSumQty();

    })
</script>

