@extends('layouts.master')
@section('header')
    <link href="{{asset('css/gijgo.min.css')}}" rel="stylesheet" type="text/css"/>
    <link href="{{asset('css/select2.min.css')}}" rel="stylesheet"/>
    <link rel="stylesheet"
          href="{{asset('css/select2-bootstrap4.min.css')}}">

@endsection
<style>
    div.sticky {
        position: sticky;
        top: 0;
        /*background-color: #beb5b5;*/
        padding-top: 8px;
        z-index: 100;
    }

    form.noStyle {
        margin: 0;
    }

    .btn-circle.btn-sm {
        width: 30px;
        height: 30px;
        padding: 6px 0px;
        border-radius: 15px;
        font-size: 8px;
        text-align: center;
    }

    .form-control {
        display: inline-block !important;
    }

</style>
@section('content')
    <form action="{{route('mat.removeImg')}}" method="POST" style="margin: 0"
          onkeypress="return event.keyCode != 13;"
          id="removeImgForm" >
        @csrf
        <div class="col-1 text-left">
            <input type="hidden" class="form-control" name="F_pk_xvmatcode" id="F_pk_xvmatcode"  readonly>
        </div>
    </form>
    <form action="{{route('mat.update')}}" method="POST" id="Form_Submit"
          enctype="multipart/form-data"
          class="noStyle"
          onsubmit="return validateForm()">
        @csrf
        @method('PUT')
        <div class="card">
            <div class="card-body">
                <div class="sticky">
                    <div class="row ">
                        <div class="col-2">
                            <h5>ฟอร์มแก้ไขข้อมูลวัสดุ</h5>
                        </div>
                        <div class="col text-right">
                            <a href="{{route('mat.index')}}" class="btn btn-danger"><i
                                    class="fas fa-long-arrow-alt-left fa-lg"></i> <span>กลับ</span></a>
                                    <button type="submit" class="btn btn-primary">บันทึก</button>
                        </div>
                    </div>
                    <hr>
                </div>
                <h5>ข้อมูลเอกสาร</h5>

                <div class="row border">

                    <div class="col border-right ">

                        @component('Materials.components.hd',['oldHD'=>$hd])
                        @endcomponent
                    </div>

                    <div class="col  ">
                        @component('Components.SupplierForMat',['isMultiple'=>true,'matsup'=>$matsup])
                        @endcomponent
                    </div>

                </div>

                <div class="row">
                    <div class="col border  ">
                        @component('Materials.components.dt',['oldDT'=>$dt])
                        @endcomponent
                    </div>
                    <div class="col  ">
                        @component('Components.upload',['oldPicture'=>$hd->xvmatpic,'hasDelete'=>true])
                        @endcomponent
                    </div>
                </div>
            </div>
        </div>
        </div>
    </form>
    <input type="hidden" name="msg" value="{{session()->get('msg')}}">
@endsection
<script src="{{asset('js/helper.js')}}"></script>
<script src="{{asset('js/jquery-3.5.1.min.js')}}"></script>
<script src="{{asset('js/gijgo.min.js')}}" defer type="text/javascript"></script>
<script src="{{asset('js/select2.min.js')}}" defer></script>
<script src="{{asset('js/sweetalert.min.js')}}"></script>
<script src="{{asset('js/pages/Material/form.js')}}"></script>
<script src="{{asset('js/helper.js')}}"></script>

<script>
    async function deleteImages(){
        let resp = swal({
            title: `ยืนยันการลบรูป ?`,
            text: "หากยืนยันแล้วไม่สามารถเปลี่ยนแปลงได้",
            icon: "warning",
            buttons: true,
            dangerMode: true,
        })
        let isOk = await resp
        if (isOk){
            var pk_xvmatcode = document.getElementById("pk_xvmatcode").value;
            document.getElementById("F_pk_xvmatcode").value = pk_xvmatcode;
            document.getElementById("removeImgForm").submit();
        }else{
            console.log('cancle')
        }
    }
    $(document).ready(function () {
        var oldList = document.getElementsByClassName("dtItems")
        let oldArr = [];
        for (let i = 0; i < oldList.length; i++) {
            oldArr.push(oldList[i].id)
        }
        var oldList2 = document.getElementsByClassName("supItems")
    let oldArr2 = [];
    for (let i = 0; i < oldList2.length; i++) {
        oldArr2.push(oldList2[i].id)
    }
    
    TriggerChange(oldArr,oldArr2)
    })
</script>
