@extends('layouts.master')
@section('header')
    <link href="{{ asset('css/gijgo.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('css/select2.min.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('css/select2-bootstrap4.min.css') }}">

@endsection
@php
    use Illuminate\Support\Facades\DB;
    $supplier = DB::table('tmstmsupplier')
        ->orderBy('XVSplCode', 'asc')
        ->get();
@endphp
@section('content')
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <div class="card">
        <div class="card-body">
            <div class="row ">
                <div class="col-6">
                    <h5 style="font-weight: bold;">รายงานการสั่งซื้อแยกตามผู้จำหน่าย</h5>
                </div>
                <div class="col-6 text-right">
                    <a href="{{route('report.dashboard.index')}}" class="btn btn-danger ">ย้อนกลับ</a>
                </div>
            </div>
            <hr>
            <div class="card-body">
                <div class="row mt-1 ">
                    <div class="card " style="max-width: 650px;min-width: 650px;margin: auto;
                    padding: 10px;">
                        <div class="col-12 text-center mt-2">
                            <h6 style="font-weight: bold ">เงื่อนไขในการเลือก</h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12 ">
                                    <h6 style="font-weight: bold">วันที่</h6>
                                    <input type="checkbox" class="mr-2" id="AllDate" onclick="AllDate()" checked>ทั้งหมด
                                    <div class="row mt-3">
                                        <p style="max-width: 100px;min-width: 100px;" class="ml-3 pr-2 text-right">
                                            ตั้งแต่วันที่</p>
                                        <input class="form-control" type="date" value="" name="DateStart" id="DateStart"
                                               style="max-width: 180px;min-width: 180px;">
                                        <p style="max-width: 100px;min-width: 100px;" class="ml-3  pr-2 text-right">
                                            ถึงวันที่</p>
                                        <input class="form-control" type="date" value="" name="DateEnd" id="DateEnd"
                                               style="max-width: 180px;min-width: 180px;">
                                    </div>
                                </div>
                            </div>
                            <div class="row mt-4">
                                <div class="col-12">
                                    <h6 style="font-weight: bold">ผู้จัดจำน่าย</h6>
                                    <input type="checkbox" class="mr-2" id="AllSpl" onclick="AllSpl()" checked>ทั้งหมด
                                    <div class="row mt-2">
                                        <p style="max-width: 100px;min-width: 100px;" class="ml-3  pr-2 text-right">จาก</p>

                                        <select class="form-control" id="SelectSupplierStart" name="XVSplCodeStart"
                                                style="max-width: 480px;min-width: 480px;">
                                            <option></option>
                                            @foreach ($supplier as $key => $item)
                                                <option data-raw="{{ json_encode($item) }}" @if (isset($oldValue) && $oldValue == $item->XVSplCode) selected @endif value="{{ $item->XVSplCode }}">
                                                    {{ $item->XVSplCode }} : {{ $item->XVSplName }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                    <div class="row mt-2">
                                        <p style="max-width: 100px;min-width: 100px;" class="ml-3  pr-2 text-right">ถึง</p>

                                        <select class="form-control" id="SelectSupplierEnd" name="XVSplCodeEnd"
                                                style="max-width: 480px;min-width:480px;">
                                            <option></option>
                                            @foreach ($supplier as $key => $item)
                                                <option data-raw="{{ json_encode($item) }}" @if (isset($oldValue) && $oldValue == $item->XVSplCode) selected @endif value="{{ $item->XVSplCode }}">
                                                    {{ $item->XVSplCode }} : {{ $item->XVSplName }}</option>
                                            @endforeach
                                        </select>

                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="row mt-1">

                            <div class="col-8 text-right">
                                <button class="btn btn-info bottom " style="vertical-align: bottom;" onclick="datareport()">
                                    export pdf</button>
                                <button class="btn btn-success bottom " style="vertical-align: bottom;" onclick="datareportexcel()">export
                                    excel</button>
                            </div>
                        </div>
                    </div>
                </div>
                <div style=" visibility: hidden;" id="a">
                    <table id="example" ></table>
                </div>
            </div>
        </div>
    </div>
    <input type="hidden" id="SplEnd" >
    <input type="hidden" id="SplStart" >
    </div>
    <script src="//unpkg.com/xlsx/dist/xlsx.full.min.js" type="text/javascript"></script>
    <script src="{{ asset('js/pages/excel/table2excel.min.js') }}"></script>
    <script>
        $(document).ready(function() {
            AllSpl();
            AllDate();
            const SplStart = $('#SelectSupplierStart').select2({
                placeholder: "เลือกผู้จัดจำหน่าย",
                theme: 'bootstrap4',
            });
            const SplEnd = $('#SelectSupplierEnd').select2({
                placeholder: "เลือกผู้จัดจำหน่าย",
                theme: 'bootstrap4',
            });
            Date.prototype.toDateInputValue = (function() {
                var local = new Date(this);
                local.setMinutes(this.getMinutes() - this.getTimezoneOffset());
                return local.toJSON().slice(0, 10);
            });

            SplStart.on('select2:select', function (e) {
                var {id, text} = (e.params.data);
                $("#SplStart").val(text.trim());
            });
            SplEnd.on('select2:select', function (e) {
                var {id, text} = (e.params.data);
                $("#SplEnd").val(text.trim());
            });

            document.getElementById('DateStart').value = new Date().toDateInputValue();
            document.getElementById('DateEnd').value = new Date().toDateInputValue();


        })

    </script>

    <script>
      function excel() 
        {
            var wb = XLSX.utils.table_to_book(document.getElementById('example'));
      XLSX.writeFile(wb, 'sample.xlsx');
      return false;
        }
        function AllSpl() {
            var checkBox = document.getElementById("AllSpl");
            if (checkBox.checked == true) {
                document.getElementById('SelectSupplierStart').disabled = true;
                document.getElementById('SelectSupplierEnd').disabled = true;
                document.getElementById('SelectSupplierStart').value = null;
                document.getElementById('SelectSupplierEnd').value = null;
            } else {
                document.getElementById('SelectSupplierStart').disabled = false;
                document.getElementById('SelectSupplierEnd').disabled = false;
            }
        }

        function AllDate() {
            var checkBox = document.getElementById("AllDate");
            if (checkBox.checked == true) {
                document.getElementById('DateStart').disabled = true;
                document.getElementById('DateEnd').disabled = true;
            } else {
                document.getElementById('DateStart').disabled = false;
                document.getElementById('DateEnd').disabled = false;
            }
        }

        function datareport() {
            var dataSet = [];
            let _token = $('meta[name="csrf-token"]').attr('content');
            const DateStart = document.getElementById('DateStart').value;
            const DateEnd = document.getElementById('DateEnd').value;
            const SplStart = document.getElementById('SelectSupplierStart').value;
            const SplEnd = document.getElementById('SelectSupplierEnd').value;
            const isAllTime = document.getElementById('AllDate').checked;
            const isAllSpl = document.getElementById('AllSpl').checked;
            //ShowValue
            const XVSplStart = document.getElementById('SplStart').value;
            const XVSplEnd = document.getElementById('SplEnd').value;

            //End Show Value
            let JsonFilter = {
                DateStart,
                DateEnd,
                SplStart:XVSplStart,
                SplEnd: XVSplEnd,
                isAllTime,
                isAllSpl,
            }
            $.ajax({
                url: '{{ route('report.201.data') }}',
                type: "POST",
                data: {
                    _token: _token,
                    DateStart,
                    DateEnd,
                    SplStart,
                    SplEnd,
                    isAllTime,
                    isAllSpl,
                },
                success: function(result) {
                    console.log(result);
                    renderPdf(result,JsonFilter);
                }
            });
        }
        function datareportexcel() {
            var dataSet = [];
            let _token = $('meta[name="csrf-token"]').attr('content');
            const DateStart = document.getElementById('DateStart').value;
            const DateEnd = document.getElementById('DateEnd').value;
            const SplStart = document.getElementById('SelectSupplierStart').value;
            const SplEnd = document.getElementById('SelectSupplierEnd').value;
            const isAllTime = document.getElementById('AllDate').checked;
            const isAllSpl = document.getElementById('AllSpl').checked;
            //ShowValue
            const XVSplStart = document.getElementById('SplStart').value;
            const XVSplEnd = document.getElementById('SplEnd').value;

            //End Show Value
            let JsonFilter = {
                DateStart,
                DateEnd,
                SplStart:XVSplStart,
                SplEnd: XVSplEnd,
                isAllTime,
                isAllSpl,
            }
            $.ajax({
                url: '{{ route('report.201.dataexcel') }}',
                type: "POST",
                data: {
                    _token: _token,
                    DateStart,
                    DateEnd,
                    SplStart,
                    SplEnd,
                    isAllTime,
                    isAllSpl,
                },
                success: function(result) {
                    console.log(result);
                    var dataSet = [];
                    var i = 0;
                    
                    $('table tbody').remove()
                    
                    $('#example').DataTable({
                        "destroy": true,
                        paging: false,
                        "data": result,
                        "columns": [

                            {
                                "title": "รหัสผู้จำหน่าย",
                                "data": "XVSplCode"
                            },
                            {
                                "title": "ชื่อผู้จำหน่าย",
                                "data": "XVSplName"
                            },
                            {
                                "title": "วันที่",
                                "data": "XDPohDocDate"
                            },
                            {   "title": "เลขที่ใบสั่งผลิต",
                                "data": "XVPohDocNo"
                            },
                            {   "title": "รหัสสินค้า",
                                "data": "xvmatcode"
                            },
                             {   "title": "ชื่อสินค้า",
                                "data": "XVPodName"
                            },
                            {
                                "title": "ยอด",
                                "data": "XFPodCostTotal"
                            },

                        ]
                    });
                         
                    if(isAllTime)
                    {
                        
                        start = "ทั้งหมด";
                         end= "ทั้งหมด";
                    }
                    else
                    {
                        start = convertDateToLocale(DateStart);
                        end= convertDateToLocale(DateEnd);
                    }
                    if(isAllSpl)
                    {
                        
                        splstart = "ทั้งหมด";
                         splend= "ทั้งหมด";
                    }
                    else
                    {
                        splstart = SplStart;
                        splend= SplEnd;
                    }

                    var htmltb = document.getElementById('example').innerHTML;
                    console.log(htmltb)
                    console.log(document.getElementsByTagName('thead')[0].innerHTML)
                    console.log(document.getElementsByTagName('tbody')[0].innerHTML)
                    document.getElementById('example').innerHTML =
                    "<thead>"+
                    "<tr><th  colspan='8' class='text-center'>201 รายงานการสั่งซื้อแยกตามผู้จำหน่าย</th></tr>"+
                    "<tr><th  colspan='8' class='text-center'> จากวันที่ "+start+" ถึงวันที่ "+end+ "</th></tr> "+
                    "<tr><th  colspan='8' class='text-center'>จากผู้จำหน่าย "+splstart+" ถึง "+splend+"</th></tr>"+
                    document.getElementsByTagName('thead')[0].innerHTML+
                    "</thead>"+
                    document.getElementsByTagName('tbody')[0].innerHTML
                    ;
                     excel();
                    $('table tbody').remove()
                    document.getElementById('a').innerHTML =" <table id='example' ></table>"
                    // th class="sorting_asc" tabindex="0" aria-controls="example" rowspan="1" colspan="1" aria-sort="ascending" aria-label="รหัสลูกค้า: activate to sort column descending
                }
            });
        }

    </script>
@endsection
<script src="{{ asset('js/pages/report/R201.js') }}"></script>
<script src="{{ asset('js/jquery-3.5.1.min.js') }}"></script>
<script src="{{ asset('js/gijgo.min.js') }}" defer type="text/javascript"></script>
<script src="{{ asset('js/select2.min.js') }}" defer></script>
<script src="{{ asset('js/sweetalert.min.js') }}"></script>
<script src="{{ asset('js/pdfmake.js') }}"></script>
