@extends('layouts.master')
@section('header')
    <link href="{{ asset('css/gijgo.min.css') }}" rel="stylesheet" type="text/css" />
    <link href="{{ asset('css/select2.min.css') }}" rel="stylesheet" />
    <link rel="stylesheet" href="{{ asset('css/select2-bootstrap4.min.css') }}">

@endsection
@php
use Illuminate\Support\Facades\DB;
$Material = DB::table('tmstmmaterial')
    ->orderBy('xvmatcode','asc')->get()->toArray();
@endphp
@section('content')
    <meta name="csrf-token" content="{{ csrf_token() }}" />
    <div class="card">
        <div class="card-body">
            <div class="row ">
                <div class="col-6">
                    <h5 style="font-weight: bold;">รายงานวัสดุคงคลัง</h5>
                </div>
                <div class="col-6 text-right">
                    <a href="{{route('report.dashboard.index')}}" class="btn btn-danger ">ย้อนกลับ</a>
                </div>
            </div>
            <hr>
            <div class="card-body">
                <div class="row mt-1 ">
                    <div class="card " style="max-width: 650px;min-width: 650px;margin: auto;
                    padding: 10px;">
                        <div class="col-12 text-center mt-2">
                            <h6 style="font-weight: bold ">เงื่อนไขในการเลือก</h6>
                        </div>
                        <div class="card-body">
                            <div class="row mt-4">
                                <div class="col-12">
                                    <h6 style="font-weight: bold">วัสดุ</h6>
                                    <input type="checkbox" class="mr-2" id="AllMat" onclick="AllMat()" checked>ทั้งหมด
                                    <div class="row mt-2">
                                        <p style="max-width: 100px;min-width: 100px;" class="ml-3  pr-2 text-right">จาก</p>

                                        <select class="form-control " id="SelectMaterialStart" name="SelectMaterial"
                                        style="max-width: 480px;min-width: 480px;" >
                                     <option></option>
                                     @foreach ($Material as $key => $item)
                                         <option value="{{$item->xvmatcode}}"> {{$item->xvmatcode}} : {{$item->xvmatname}}</option>
                                     @endforeach
                                 </select>
                                    </div>
                                    <div class="row mt-2">
                                        <p style="max-width: 100px;min-width: 100px;" class="ml-3  pr-2 text-right">ถึง</p>

                                        <select class="form-control " id="SelectMaterialEnd" name="SelectMaterial"
                                        style="max-width: 480px;min-width: 480px;">
                                     <option></option>
                                     @foreach ($Material as $key => $item)
                                         <option value="{{$item->xvmatcode}}"> {{$item->xvmatcode}} : {{$item->xvmatname}}</option>
                                     @endforeach
                                 </select>

                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="row mt-1">

                            <div class="col-8 text-right">
                                <button class="btn btn-info bottom " style="vertical-align: bottom;" onclick="datareport()">
                                    export pdf</button>
                                <button class="btn btn-success bottom " style="vertical-align: bottom;" onclick="datareportexcel()">export
                                    excel</button>
                            </div>
                        </div>
                        <div style=" visibility: hidden;" id="a">
                            <table id="example" ></table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <input type="hidden" id="MatStart">
        <input type="hidden" id="MatEnd">
    </div>
    <script src="{{ asset('js/pages/excel/table2excel.min.js') }}"></script>
    <script src="//unpkg.com/xlsx/dist/xlsx.full.min.js" type="text/javascript"></script>

    <script>
        $(document).ready(function() {
            AllMat();
            const MatStart = $('#SelectMaterialStart').select2({
                placeholder: "กรุณาเลือกวัสดุ",
                theme: 'bootstrap4',
            });
            const MatEnd = $('#SelectMaterialEnd').select2({
                placeholder: "กรุณาเลือกวัสดุ",
                theme: 'bootstrap4',
            });
            MatStart.on('select2:select', function (e) {
                var {id, text} = (e.params.data);
                $("#MatStart").val(text.trim());
            });
            MatEnd.on('select2:select', function (e) {
                var {id, text} = (e.params.data);
                $("#MatEnd").val(text.trim());
            });
            Date.prototype.toDateInputValue = (function() {
                var local = new Date(this);
                local.setMinutes(this.getMinutes() - this.getTimezoneOffset());
                return local.toJSON().slice(0, 10);
            });

            document.getElementById('DateStart').value = new Date().toDateInputValue();
            document.getElementById('DateEnd').value = new Date().toDateInputValue();


        })

    </script>

    <script>
         function excel() {
            var wb = XLSX.utils.table_to_book(document.getElementById('example'));
            XLSX.writeFile(wb, '303 รายงานวัสดุคงคลัง ' + convertDateToLocale(new Date().toDateInputValue()) + '.xlsx');
            return false;
        }
        function AllMat() {
            var checkBox = document.getElementById("AllMat");
            if (checkBox.checked == true) {
                document.getElementById('SelectMaterialStart').disabled = true;
                document.getElementById('SelectMaterialEnd').disabled = true;
                document.getElementById('SelectMaterialStart').value = null;
                document.getElementById('SelectMaterialEnd').value = null;
            } else {
                document.getElementById('SelectMaterialStart').disabled = false;
                document.getElementById('SelectMaterialEnd').disabled = false;
            }
        }
        function datareport() {
            var dataSet = [];
            let _token = $('meta[name="csrf-token"]').attr('content');
            const MatStart = document.getElementById('SelectMaterialStart').value;
            const MatEnd = document.getElementById('SelectMaterialEnd').value;
            const isAllMat = document.getElementById('AllMat').checked;
            //ShowValue
            const XVMatStart = document.getElementById('MatStart').value;
            const XVMatEnd = document.getElementById('MatEnd').value;

            //End Show Value
            let JsonFilter = {
                MatStart: XVMatStart,
                MatEnd: XVMatEnd,
                isAllMat,
            }
            $.ajax({
                url: '{{ route('report.303.data') }}',
                type: "POST",
                data: {
                    _token: _token,
                    MatStart,
                    MatEnd,
                    isAllMat,
                },
                success: function (result) {
                    console.log(result);
                    renderPdf(result, JsonFilter);
                }
            });
        }
        function datareportexcel() {
            var dataSet = [];
            let _token = $('meta[name="csrf-token"]').attr('content');
            const MatStart = document.getElementById('SelectMaterialStart').value;
            const MatEnd = document.getElementById('SelectMaterialEnd').value;
            const isAllMat = document.getElementById('AllMat').checked;
            //ShowValue
            const XVMatStart = document.getElementById('MatStart').value;
            const XVMatEnd = document.getElementById('MatEnd').value;

            //End Show Value
            let JsonFilter = {
                MatStart: XVMatStart,
                MatEnd: XVMatEnd,
                isAllMat,
            }
            $.ajax({
                url: '{{ route('report.303.data') }}',
                type: "POST",
                data: {
                    _token: _token,
                    MatStart,
                    MatEnd,
                    isAllMat,
                },
                success: function (result) {
                    console.log(result);
                    var dataSet = [];
                    for (let index = 0; index < result.length; index++) {
                        var nf = new Intl.NumberFormat();

                        var row = [
                            result[index].xvmatcode,
                            result[index].xvmatname,
                            result[index].qty,
                            result[index].factorName+'/'+result[index].minimumFactor,

                        ];
                        dataSet.push(row);
                    }
                    $('table tbody').remove()
                    
                    $('#example').DataTable({
                        "destroy": true,
                        paging: false,
                        "data": dataSet,
                        "columns": [

                            {
                                "title": "รหัสวัสดุ",
                            },
                           
                            {
                                "title": "ชื่อวัสดุ",
                            },
                             {
                                "title": "คงคลัง",
                            },
                            {
                                "title": "หน่วยนับ",
                            }
                        ]
                    });

                    if(isAllMat)
                    {
                        
                        matstart = "ทั้งหมด";
                         matend= "ทั้งหมด";
                    }
                    else
                    {
                        matstart =MatStart;
                        matend= MatEnd;
                    }

                    var htmltb = document.getElementById('example').innerHTML;
                    console.log(htmltb)
                    console.log(document.getElementsByTagName('thead')[0].innerHTML)
                    console.log(document.getElementsByTagName('tbody')[0].innerHTML)
                    document.getElementById('example').innerHTML =
                        "<thead>" +
                        "<tr><th  colspan='8' class='text-center'>303 รายงานวัสดุคงคลัง</th></tr>" +
                        "<tr><th  colspan='8' class='text-center'> วันที่ "+ convertDateToLocale(new Date().toDateInputValue())+"</th></tr> "+
                        "<tr><th  colspan='8' class='text-center'>จากวัสดุ " + matstart + " ถึง " + matend +
                        "</th></tr>" +
                        document.getElementsByTagName('thead')[0].innerHTML +
                        "</thead>" +
                        document.getElementsByTagName('tbody')[0].innerHTML;
                    excel();
                    $('table tbody').remove()
                    document.getElementById('a').innerHTML = " <table id='example' ></table>"
                }
            });
        }
        function convertDateToLocale(date) {
    return new Date(date).toLocaleDateString('th')
}
    </script>
@endsection
<script src="{{ asset('js/pages/report/R303.js') }}"></script>
<script src="{{ asset('js/jquery-3.5.1.min.js') }}"></script>
<script src="{{ asset('js/gijgo.min.js') }}" defer type="text/javascript"></script>
<script src="{{ asset('js/select2.min.js') }}" defer></script>
<script src="{{ asset('js/sweetalert.min.js') }}"></script>
<script src="{{ asset('js/pdfmake.js') }}"></script>
