@extends('layouts.master')
@section('content')
  <div class="card">
    <div class="card-body">
      <div class="row">
        <div class="col-6">
          <h5>ฟอร์มเพิ่มข้อมูล Material</h5>
        </div>
        <div class="col-6 text-right">
          <a href="{{route('material')}}" class="btn btn-success"><i class="fas fa-long-arrow-alt-left fa-lg"></i> <span>กลับ</span></a>
        </div>
      </div>
      <hr>
      <div class="row">
        <div class="col-12 pr-5 pl-5">
          <form action="{{route('add_material')}}" method="POST">
            @csrf
            <div class="form-row mt-5">
              <div class="col-3">
                <label for="">เลือกประเภท Material</label>
                <select id="" class="form-control" name="xvmtycode">
                  <option value="0">เลือกประเภท</option>
                  @foreach ($types as $type)
                      <option value="{{$type->xvmtycode}}">{{$type->xvmtyname}}</option>
                  @endforeach
                </select>
              </div>
              <div class="col-3">
                <label for="">เลือกกลุ่ม Material</label>
                <select id="" class="form-control" name="xvmgpcode">
                  <option value="0">เลือกกลุ่ม</option>
                  @foreach ($groups as $group)
                      <option value="{{$group->xvmgpcode}}">{{$group->xvmgpname}}</option>
                  @endforeach
                </select>
              </div>
              <div class="col-6">
                <label for="">เลือก Supplier</label>
                <select name="xvsplcode" id="" class="form-control">
                  <option value="0">เลือก Supplier</option>
                  @foreach ($spls as $spl)
                      <option value="{{$spl->XVSplCode}}">{{$spl->XVSplName}}</option>
                  @endforeach
                </select>
              </div>
            </div>
            <div class="form-row mt-3">
              <div class="col-4">
                <label for="">รหัส Material</label>
                <input type="text" class="form-control" name="xvmatcode">
              </div>
              <div class="col-4">
                <label for="">ชื่อ Material</label>
                <input type="text" class="form-control" name="xvmatname">
              </div>
              <div class="col-4">
                <label for="">คำอธิบาย Material</label>
                <input type="text" class="form-control" name="xvmatdes">
              </div>
            </div>
            <div class="form-row mt-3 mb-5">
              <div class="col-6 text-center">
                <a href="{{route('material')}}" class="btn btn-danger">ยกเลิก</a>
              </div>
              <div class="col-6 text-center">
                <button type="submit" class="btn btn-primary">บันทึก</button>
              </div>
            </div>
          </form>
        </div>
      </div>
    </div>
  </div>
@endsection
