<?php
//$today = Carbon\Carbon::createFromFormat('Y-m-d',$oldItem->XDOrhDocDate)->format('d-m-Y')
?>
@extends('layouts.master')
@section('header')
    <link href="{{asset('css/gijgo.min.css')}}" rel="stylesheet" type="text/css"/>
    <link href="{{asset('css/select2.min.css')}}" rel="stylesheet"/>
    <link rel="stylesheet"
          href="{{asset('css/select2-bootstrap4.min.css')}}">
@endsection
@section('content')
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-6">
                    <h5>ฟอร์มเพิ่มข้อมูล Order สินค้า</h5>
                </div>
                <div class="col-6 text-right">
                    <a href="{{route('order.index')}}" class="btn btn-success"><i
                            class="fas fa-long-arrow-alt-left fa-lg"></i> <span>กลับ</span></a>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="col-12 pr-5 pl-5">
                    <form action="{{route('order.update')}}" method="POST" id="Form_Submit"
                          onsubmit="return validateForm()">
                        @csrf
                        @method('PUT')
                        <div class="form-row row mt-3">
                            <div class="col-2">
                                <label for="">รหัส Order</label>
                                <input type="text" class="form-control" name="XVOrhDocNo" value="{{$oldItem->XVOrhDocNo}}" readonly>
                            </div>
                            <div class="col-4">
                                <label for="">เลือกลูกค้า</label>
                                <select class="form-control" id="SelectCustomer" name="XVCstCode">
                                    <option></option>
                                    @foreach ($customers as $key => $item)
                                        <option value="{{$item->XVCstCode}}" @if($item->XVCstCode === $oldItem->XVCstCode) selected @endif>{{$item->XVCstName}}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="col-2">
                                <label for="">สถานะเอกสาร</label>
                                <input type="text" class="form-control" readonly name="XVOrhDocStatus"
                                       value="{{$oldItem->XVOrhDocStatus}}"
                                       id="XVOrhDocStatus">
                            </div>
                            <div class="col-2">
                                <label for="">วันที่เอกสาร</label>
                                <input class="form-control" readonly name="XDOrhDocDate"
                                       id="datepicker"
                                       autocomplete="off"
                                       value="{{Carbon\Carbon::createFromFormat('Y-m-d',$oldItem->XDOrhDocDate)->format('d-m-Y')}}"
                                       style="background-color: #fff;">
                            </div>
                        </div>
                        <div class="dropdown-divider"></div>

                        <div class="form-row mt-3">
                            <div class="col-12">
                                <label for="">เลือกสินค้า</label>
                                <select class="form-control" id="SelectProduct" name="SelectProduct" multiple="multiple">
                                    <option></option>
                                    @foreach ($products as $key => $item)
                                        <option value="{{$item->xvpdtcode}}_{{$item->XVPszName}}">{{$item->xvpdtname}} Size : {{$item->XVPszName}}</option>
                                    @endforeach
                                </select>
                            </div>
                        </div>

                        <div class="dropdown-divider "></div>
                        <div id="Control">
                            @foreach ($oldItem->DT as $key => $item)

                            <div class="form-row mt-3 MatControl" id="{{$item->xvpdtcode}}_{{$item->XVPszName}}">
                                <div class="col-5">
                                    <label for="">Product</label>
                                    <input type="text" class="form-control" value="{{$item->xvpdtname}} Size : {{$item->XVPszName}}"
                                           readonly>
                                    <input type="hidden" name="xvpdtcode[]" value="{{$item->xvpdtcode}}">
                                    <input type="hidden" name="XVPszName[]" value="{{$item->XVPszName}}">
                                </div>
                                <div class="col-2">
                                    <label for="">จำนวน</label>
                                    <input type="number" class="form-control" name="XIOrdQty[]" value="{{$item->XIOrdQty}}" >
                                </div>
                                <!--                                <button type="button" class="btn btn-danger mt-3" onclick="remove(this)">Remove</button>-->
                            </div>
                            @endforeach
                        </div>


                        <div class="form-row mt-3 mb-5">
                            <div class="col-6 text-center">
                                <a href="{{route('order.index')}}" class="btn btn-danger">ยกเลิก</a>
                            </div>
                            <div class="col-6 text-center">
                                <button type="submit" class="btn btn-primary">บันทึก</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
<script src="{{asset('js/jquery-3.5.1.min.js')}}"></script>
<script src="{{asset('js/gijgo.min.js')}}" defer type="text/javascript"></script>
<script src="{{asset('js/select2.min.js')}}" defer></script>
<script src="{{asset('js/sweetalert.min.js')}}"></script>
<script src="{{asset('js/pages/Order/form.js')}}"></script>
<script>

    $(document).ready(function () {
        var oldList = document.getElementsByClassName("MatControl")
        let oldArr = [];
        for(let i = 0 ; i < oldList.length; i++){
            oldArr.push(oldList[i].id)
        }
        TriggerChange(oldArr)

    })
</script>
