@extends('layouts.master')
@section('content')
    <div class="card">
        <div class="card-body">
            <div class="row">
                <div class="col-6">
                    <h5>ฟอร์มเพิ่มข้อมูล Product</h5>
                </div>
                <div class="col-6 text-right">
                    <a href="{{route('product.index')}}" class="btn btn-success"><i
                            class="fas fa-long-arrow-alt-left fa-lg"></i> <span>กลับ</span></a>
                </div>
            </div>
            <hr>
            <div class="row">
                <div class="col-12 pr-5 pl-5">
                    <form action="{{route('product.update')}}" method="POST" id="Form_Submit"
                          onsubmit="return validateForm()">
                        @csrf
                        @method('PUT')
                        <input name="_method" type="hidden" value="PUT">
                        <div class="form-row mt-3">
                            <div class="col-4">
                                <label for="">รหัส Product</label>
                                <input type="text" class="form-control" name="xvpdtcode" value="{{$product->xvpdtcode}}"
                                       readonly>
                            </div>
                            <div class="col-4">
                                <label for="">ชื่อ Product</label>
                                <input type="text" class="form-control" name="xvpdtname" value="{{$product->xvpdtname}}"
                                       id="xvpdtname">
                            </div>
                        </div>
                        <div id="SizeControl">
                            @foreach($product->Size as $item)
                                <div class="form-row mt-3">
                                    <div class="row-4">
                                        <div class="col-12">
                                            <label for="">Size</label>
                                            <input type="text" class="form-control" value="{{$item}}" maxlength="10"
                                                   name="XVPszName[]">
                                        </div>

                                    </div>
                                    <button type="button" class="btn btn-danger btn-sm mt-4" onclick="remove(this)">Delete</button>

                                </div>
                            @endforeach
                            <small id="emailHelp" class="form-text text-muted">การสร้าง Product ต้องมี Size
                                อย่างน้อยหนึ่งประเภท</small>
                        </div>

                        <button type="button" class="btn btn-success mt-3" onclick="createSize()">+ Size</button>

                        <div class="form-row mt-3 mb-5">
                            <div class="col-6 text-center">
                                <a href="{{route('product.index')}}" class="btn btn-danger">ยกเลิก</a>
                            </div>
                            <div class="col-6 text-center">
                                <button type="submit" class="btn btn-primary">บันทึก</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
<script src="https://unpkg.com/sweetalert/dist/sweetalert.min.js"></script>
<script>
    function getArrayInput(NameElement) {
        var input = document.getElementsByName(NameElement);
        let arr = []
        for (var i = 0; i < input.length; i++) {
            arr.push(input[i].value)
        }
        return arr;
    }

    function createSize() {
        const SizeControl = document.getElementById("SizeControl")
        SizeControl.insertAdjacentHTML('beforeend', `   <div class="form-row mt-3" >
                                <div class="row-4">
                                    <div class="col-12">
                                        <label for="">Size</label>
                                        <input type="text" class="form-control" maxlength="10" name="XVPszName[]">

                                    </div>

                                </div>
 <button type="button" class="btn btn-danger btn-sm mt-4" onclick="remove(this)">Delete</button>

                            </div>
`)
    }

    function remove(e) {
        e.parentNode.remove()
    }

    function validateForm() {
        let xvpdtname = document.querySelector("#xvpdtname")
        if (xvpdtname.value.trim().length > 0) {
            const input = getArrayInput('XVPszName[]');
            const itemFillter = input.filter((item) => item.trim().length === 0)
            console.log(itemFillter)
            if (itemFillter.length > 0) {
                swal('กรุณากรอกชื่อ Size', "กรุณากรอกชื่อ Size ให้ครบทุกช่อง", "warning")
            } else {
                if(input.length>0){
                    return true

                }else{
                    swal('กรุณากรอกชื่อ Size', "กรุณากรอกชื่อ Size อย่างน้อย 1 ช่อง", "warning")
                }
            }
        } else {
            swal('กรุณากรอกชื่อ Product', "กรุณากรอกชื่อสินค้า", "warning")

        }
        return false

    }
</script>
