<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('login');
});
Route::get('/home', function () {
    return redirect()->route('dashboard');
});
Auth::routes(['register' => false]);
Route::group(['middleware' => ['auth']], function () {

    Route::get('dashboard', 'DashBoardController@index')->name('dashboard');

    // Customer
    Route::group(['middleware' => ['CheckMenuPerm:1']], function () {
        Route::get('customer', 'CustomerController@index')->name('customer');
        Route::get('form_add_customer', function () {
            return view('customer.form_add_customer');
        })->name('form_add_customer');
        Route::get('form_edit_customer/{id}', 'CustomerController@frmEdit')->name('form_edit_customer');
        Route::get('del_customer/{id}', 'CustomerController@delCustomer')->name('del_customer');
        Route::post('add_customer', 'CustomerController@addCustomer')->name('add_customer');
        Route::post('edit_customer', 'CustomerController@editCustomer')->name('edit_customer');
    });
    Route::group(['middleware' => ['CheckMenuPerm:2']], function () {
        Route::get('supplier', 'SupplierController@index')->name('supplier');
        Route::get('frm_add_sup', function () {
            return view('supplier.frm_add_sup');
        })->name('frm_add_sup');
        Route::post('add', 'SupplierController@add_supplier')->name('add_supplier');
        Route::get('frm_edit_supplier/{id}', 'SupplierController@frmEdit')->name('frm_edit_supplier');
        Route::post('edit_supplier', 'SupplierController@edit_supplier')->name('edit_supplier');
        Route::get('del_supplier/{id}', 'SupplierController@delSupplier')->name('del_supplier');
        Route::get('view_detail_supplier/{id}', 'SupplierController@viewSupplier')->name('view_detail_supplier');
    });

    Route::group(['middleware' => ['CheckMenuPerm:3']], function () {
        Route::get('material_unit', 'MaterialController@materialUnit')->name('material_unit');
        Route::post('add_material_unit', 'MaterialController@addMatUnit')->name('add_material_unit');
        Route::post('edit_material_unit', 'MaterialController@editMatUnit')->name('edit_material_unit');
        Route::get('del_material_unit/{id}', 'MaterialController@delMatUnit')->name('del_material_Unit');
    });

    Route::group(['middleware' => ['CheckMenuPerm:4']], function () {
        Route::get('material_type', 'MaterialController@materialType')->name('material_type');
        Route::post('add_material_type', 'MaterialController@addMatType')->name('add_material_type');
        Route::post('edit_material_type', 'MaterialController@editMatType')->name('edit_material_type');
        Route::get('del_material_type/{id}', 'MaterialController@delMatType')->name('del_material_type');
    });

    Route::group(['middleware' => ['CheckMenuPerm:5']], function () {
        Route::get('material_group', 'MaterialController@materialGroup')->name('material_group');
        Route::post('add_material_group', 'MaterialController@addMatGroup')->name('add_material_group');
        Route::post('edit_material_group', 'MaterialController@editMatGroup')->name('edit_material_group');
        Route::get('del_material_group/{id}', 'MaterialController@delMatGroup')->name('del_material_group');
    });
    Route::group(['middleware' => ['CheckMenuPerm:6'], 'prefix' => 'Materials', 'as' => 'mat.'], function () {
        Route::get('/', 'MaterialsController@index')->name('index');
        Route::get('/create', 'MaterialsController@FormInsert')->name('add');
        Route::get('/edit/{xvmatcode}', 'MaterialsController@FormEdit')->name('edit');
        //    Route::get('/view/{XVPohDocNo}', 'POController@FormView')->name('view');
        Route::post('/', 'MaterialsController@Store')->name('store');
        //    Route::post('/UpdateStatus', 'POController@ChangeStatus')->name('updateStatus');
        Route::put('/', 'MaterialsController@Update')->name('update');
        Route::post('/removeImg', 'MaterialsController@removeImg')->name('removeImg');
    });
    Route::group(['middleware' => ['CheckMenuPerm:7'], 'prefix' => 'Item', 'as' => 'item.'], function () {
        Route::get('/', 'MasterItemController@index')->name('index');
        Route::get('/create', 'MasterItemController@FormInsert')->name('add');
        Route::get('/edit/{xvpdtcode}', 'MasterItemController@FormEdit')->name('edit');
        Route::post('/', 'MasterItemController@Store')->name('store');
        Route::put('/', 'MasterItemController@Update')->name('update');

        Route::get('/upload/{xvpdtcode}', 'MasterItemController@FormUpload')->name('upload');
        Route::post('/upload', 'MasterItemController@StorePicture')->name('storePicture');
        Route::post('/deletePicture', 'MasterItemController@deletePicture')->name('deletePicture');

        Route::post('/link', 'MasterItemController@StoreLink')->name('StoreLink');
        Route::delete('/link', 'MasterItemController@DeleteLink')->name('DeleteLink');

        Route::post('/removeImg', 'MasterItemController@removeImg')->name('removeImg');
    });
    Route::group(['middleware' => ['CheckMenuPerm:7'], 'prefix' => 'ItemSize', 'as' => 'itemSize.'], function () {
        Route::get('/{xvpdtcode}', 'MasterItemSizeController@index')->name('index');
        Route::put('/', 'MasterItemSizeController@Update')->name('update');
    });
    Route::group(['middleware' => ['CheckMenuPerm:7'], 'prefix' => 'ItemBomSize', 'as' => 'itemBomSize.'], function () {
        Route::get('/{xvpdtcode}/{XVPszName}', 'MasterItemBomSizeController@index')->name('index');
        Route::put('/', 'MasterItemBomSizeController@Update')->name('update');
    });
    Route::group(['middleware' => ['CheckMenuPerm:7'], 'prefix' => 'productSize', 'as' => 'productSize.'], function () {
        Route::delete('/deleteProduct/{pdtCode}/{sizeCode}', 'ProductSizeController@Delete')->name('delete');
    });
    Route::group(['middleware' => ['CheckMenuPerm:7'], 'prefix' => 'bom', 'as' => 'bom.'], function () {
        Route::get('/{pdtCode}/Add', 'BomController@FormInsert')->name('add');
        Route::post('', 'BomController@store')->name('store');
    });
    Route::group(['middleware' => ['CheckMenuPerm:7'], 'prefix' => 'bomSize', 'as' => 'bomSize.'], function () {
        Route::get('/{pdtCode}/{sizeCode}/Add', 'BomSizeController@FormInsert')->name('add');
        Route::post('', 'BomSizeController@store')->name('store');
        Route::get('/recepie/{pdtCode}/{sizeCode?}', 'BomSizeController@Recepie')->name('recepie');
    });


    Route::group(['prefix' => 'po', 'as' => 'po.'], function () {
        Route::get('/', 'POController@index')->name('index');
        Route::get('/create', 'POController@FormInsert')->name('add');
        Route::get('/edit/{XVPohDocNo}', 'POController@FormEdit')->name('edit');
        Route::post('/', 'POController@Store')->name('store');
        Route::post('/UpdateStatus', 'POController@ChangeStatus')->name('updateStatus');
        Route::put('/', 'POController@Update')->name('update');
        Route::get('/getOld/{docNo}', 'POController@getOldDataByDocNO')->name('getOld');
    });
    Route::group(['prefix' => 'order', 'as' => 'order.'], function () {
        Route::get('/', 'OrderController@index')->name('index');
        Route::get('/create', 'OrderController@FormInsert')->name('add');
        Route::get('/edit/{XVOrhDocNo}', 'OrderController@FormEdit')->name('edit');

        Route::post('/', 'OrderController@Store')->name('store');
        Route::put('/', 'OrderController@Update')->name('update');


        Route::post('/UpdateStatus', 'OrderController@ChangeStatus')->name('updateStatus');
        Route::get('/getDataForPDF/{docNo}', 'OrderController@getOldDataByDocNOPDFBoom')->name('getPDFData');
        Route::get('/getDataForPDFBOM/{docNo}', 'OrderController@getDataForPDFBOM')->name('getPDFData');
    });

    Route::group(['prefix' => 'gr', 'as' => 'gr.'], function () {
        Route::get('/', 'GRController@index')->name('index');
        Route::get('/create/{XVPohDocNo}', 'GRController@FormInsert')->name('add');
        Route::get('/edit/{XVGrhDocNo}', 'GRController@FormEdit')->name('edit');
        Route::post('/', 'GRController@Store')->name('store');
        Route::post('/UpdateStatus', 'GRController@ChangeStatus')->name('updateStatus');
        Route::put('/', 'GRController@Update')->name('update');
        Route::get('/getDataForPDF/{docNo}', 'GRController@getDataForPDF')->name('pdf');
    });
    Route::group(['prefix' => 'gi', 'as' => 'gi.'], function () {
        Route::get('/', 'GIController@index')->name('index');
        Route::get('/create', 'GIController@FormInsertEmpty')->name('addEmptyOr');
        Route::get('/create/{DocNo}', 'GIController@FormInsert')->name('add');
        Route::get('/edit/{DocNo}', 'GIController@FormEdit')->name('edit');
        Route::post('/', 'GIController@Store')->name('store');
        Route::post('/UpdateStatus', 'GIController@ChangeStatus')->name('updateStatus');
        Route::put('/', 'GIController@Update')->name('update');
        Route::get('/getDataForPDF/{docNo}', 'GIController@getDataForPDF')->name('pdf');


        //        For GI Without OrderNo.
        Route::post('/emptyOr', 'GIController@StoreEmpty')->name('storeEmpty');
        Route::put('/emptyOr', 'GIController@UpdateEmpty')->name('updateEmpty');
    });
    Route::group(['prefix' => 'Adjust', 'as' => 'adj.'], function () {
        Route::get('/', 'StockAdjustController@index')->name('index');
        Route::get('/create', 'StockAdjustController@FormInsert')->name('add');
        Route::post('/', 'StockAdjustController@Store')->name('store');
        Route::get('/edit/{DocNo}', 'StockAdjustController@FormEdit')->name('edit');
        Route::put('/', 'StockAdjustController@Update')->name('update');

        Route::post('/UpdateStatus', 'StockAdjustController@ChangeStatus')->name('updateStatus');
    });
    Route::group(['prefix' => 'FinishGoodReceive', 'as' => 'fr.'], function () {
        Route::get('/', 'FinishGoodReceiveController@index')->name('index');
        Route::get('/create/{DocNo}', 'FinishGoodReceiveController@FormInsert')->name('add');

        Route::get('/edit/{XVOrhDocNo}', 'FinishGoodReceiveController@FormEdit')->name('edit');
        Route::post('/', 'FinishGoodReceiveController@Store')->name('store');
        Route::put('/', 'FinishGoodReceiveController@Update')->name('update');
        Route::post('/UpdateStatus', 'FinishGoodReceiveController@ChangeStatus')->name('updateStatus');
        Route::get('/getDataForPDF/{docNo}', 'FinishGoodReceiveController@getDataForPDF')->name('pdf');
    });
    Route::group(['prefix' => 'FinishGoodIssued', 'as' => 'fi.'], function () {
        Route::get('/', 'FinishGoodIssuedController@index')->name('index');
        Route::get('/create', 'FinishGoodIssuedController@FormInsert')->name('add');
        Route::get('/edit/{DocNo}', 'FinishGoodIssuedController@FormEdit')->name('edit');
        Route::post('/', 'FinishGoodIssuedController@Store')->name('store');
        Route::put('/', 'FinishGoodIssuedController@Update')->name('update');
        Route::post('/UpdateStatus', 'FinishGoodIssuedController@ChangeStatus')->name('updateStatus');
        Route::get('/getDataForPDF/{docNo}', 'FinishGoodIssuedController@getDataForPDF')->name('pdf');
    });
    Route::group(['prefix' => 'FinishGoodAdjust', 'as' => 'fa.'], function () {
        Route::get('/', 'FinishGoodAdjustController@index')->name('index');
        Route::get('/create', 'FinishGoodAdjustController@FormInsert')->name('add');

        Route::get('/edit/{XVOrhDocNo}', 'FinishGoodAdjustController@FormEdit')->name('edit');
        Route::post('/', 'FinishGoodAdjustController@Store')->name('store');
        Route::put('/', 'FinishGoodAdjustController@Update')->name('update');
        Route::post('/UpdateStatus', 'FinishGoodAdjustController@ChangeStatus')->name('updateStatus');
        Route::get('/getDataForPDF/{docNo}', 'FinishGoodAdjustController@getDataForPDF')->name('pdf');
    });

    Route::group(['middleware' => ['CheckMenuPerm:16'], 'prefix' => 'Stockcard', 'as' => 'stk.'], function () {
        Route::get('/{xvmatcode?}', 'StockCardController@index')->name('index');
        Route::get('/SumQty/{xvmatcode}', 'StockCardController@SumQty')->name('SumQty');
        Route::post('/balance', 'StockCardController@Balance')->name('balance');
    });
    Route::group(['middleware' => ['CheckMenuPerm:17'], 'prefix' => 'StockcardProduct', 'as' => 'stkpdt.'], function () {
        Route::get('/{xvpdtcode?}', 'StockcardProductController@index')->name('index');
        Route::get('/SumQty/{xvpdtcode}', 'StockcardProductController@SumQty')->name('SumQty');
        Route::post('/balance', 'StockcardProductController@Balance')->name('balance');
    });
    Route::group(['middleware' => ['CheckMenuPerm:18'], 'prefix' => 'report', 'as' => 'report.'], function () {

        Route::group(['prefix' => 'dashboard', 'as' => 'dashboard.'], function () {
            Route::get('/', 'ReportController@index')->name('index');
        });
        Route::group(['prefix' => '101', 'as' => '101.'], function () {
            Route::get('/', 'Report\Report101Controller@index')->name('index');
            Route::post('/data', 'Report\Report101Controller@data')->name('data');
            Route::post('/dataexcel', 'Report\Report101Controller@datexcel')->name('dataexcel');
        });

        Route::group(['prefix' => '102', 'as' => '102.'], function () {
            Route::get('/', 'Report\Report102Controller@index')->name('index');
            Route::post('/data', 'Report\Report102Controller@data')->name('data');
            Route::post('/dataexcel', 'Report\Report102Controller@datexcel')->name('dataexcel');
        });

        Route::group(['prefix' => '201', 'as' => '201.'], function () {
            Route::get('/', 'Report\Report201Controller@index')->name('index');
            Route::post('/data', 'Report\Report201Controller@data')->name('data');
            Route::post('/dataexcel', 'Report\Report201Controller@datexcel')->name('dataexcel');
        });

        Route::group(['prefix' => '202', 'as' => '202.'], function () {
            Route::get('/', 'Report\Report202Controller@index')->name('index');
            Route::post('/data', 'Report\Report202Controller@data')->name('data');
            Route::post('/dataexcel', 'Report\Report202Controller@datexcel')->name('dataexcel');
        });

        Route::group(['prefix' => '301', 'as' => '301.'], function () {
            Route::get('/', 'Report\Report301Controller@index')->name('index');
            Route::post('/data', 'Report\Report301Controller@data')->name('data');
            Route::post('/dataexcel', 'Report\Report301Controller@datexcel')->name('dataexcel');
        });

        Route::group(['prefix' => '302', 'as' => '302.'], function () {
            Route::get('/', 'Report\Report302Controller@index')->name('index');
            Route::post('/data', 'Report\Report302Controller@data')->name('data');
            Route::post('/dataexcel', 'Report\Report302Controller@datexcel')->name('dataexcel');
        });
        Route::group(['prefix' => '303', 'as' => '303.'], function () {
            Route::get('/', 'Report\Report303Controller@index')->name('index');
            Route::post('/data', 'Report\Report303Controller@data')->name('data');
            Route::post('/dataexcel', 'Report\Report303Controller@datexcel')->name('dataexcel');
        });

        Route::group(['prefix' => '304', 'as' => '304.'], function () {
            Route::get('/', 'Report\Report304Controller@index')->name('index');
            Route::post('/data', 'Report\Report304Controller@data')->name('data');
            Route::post('/dataexcel', 'Report\Report304Controller@datexcel')->name('dataexcel');
        });
        Route::group(['prefix' => '305', 'as' => '305.'], function () {
            Route::get('/', 'Report\Report305Controller@index')->name('index');
            Route::post('/data', 'Report\Report305Controller@data')->name('data');
            Route::post('/dataexcel', 'Report\Report305Controller@datexcel')->name('dataexcel');
        });
        Route::group(['prefix' => '306', 'as' => '306.'], function () {
            Route::get('/', 'Report\Report306Controller@index')->name('index');
            Route::post('/data', 'Report\Report306Controller@data')->name('data');
            Route::post('/dataexcel', 'Report\Report306Controller@datexcel')->name('dataexcel');
        });
        Route::group(['prefix' => '307', 'as' => '307.'], function () {
            Route::get('/', 'Report\Report307Controller@index')->name('index');
            Route::post('/data', 'Report\Report307Controller@data')->name('data');
            Route::post('/dataexcel', 'Report\Report307Controller@datexcel')->name('dataexcel');
        });

        Route::group(['prefix' => '401', 'as' => '401.'], function () {
            Route::get('/', 'Report\Report401Controller@index')->name('index');
            Route::post('/data', 'Report\Report401Controller@data')->name('data');
            Route::post('/dataexcel', 'Report\Report401Controller@datexcel')->name('dataexcel');
        });

        Route::group(['prefix' => '402', 'as' => '402.'], function () {
            Route::get('/', 'Report\Report402Controller@index')->name('index');
            Route::post('/data', 'Report\Report402Controller@data')->name('data');
            Route::post('/dataexcel', 'Report\Report402Controller@datexcel')->name('dataexcel');
        });
        Route::group(['prefix' => '403', 'as' => '403.'], function () {
            Route::get('/', 'Report\Report403Controller@index')->name('index');
            Route::post('/data', 'Report\Report403Controller@data')->name('data');
            Route::post('/dataexcel', 'Report\Report403Controller@datexcel')->name('dataexcel');
        });

        Route::group(['prefix' => '404', 'as' => '404.'], function () {
            Route::get('/', 'Report\Report404Controller@index')->name('index');
            Route::post('/data', 'Report\Report404Controller@data')->name('data');
            Route::post('/dataexcel', 'Report\Report404Controller@datexcel')->name('dataexcel');
        });
        Route::group(['prefix' => '405', 'as' => '405.'], function () {
            Route::get('/', 'Report\Report405Controller@index')->name('index');
            Route::post('/data', 'Report\Report405Controller@data')->name('data');
            Route::post('/dataexcel', 'Report\Report405Controller@datexcel')->name('dataexcel');
        });
        Route::group(['prefix' => '406', 'as' => '406.'], function () {
            Route::get('/', 'Report\Report406Controller@index')->name('index');
            Route::post('/data', 'Report\Report406Controller@data')->name('data');
            Route::post('/dataexcel', 'Report\Report406Controller@datexcel')->name('dataexcel');
        });
        Route::post('/select/201', 'ReportController@select201')->name('Select201');
    });

    Route::group(['middleware' => ['CheckMenuPerm:19'], 'prefix' => 'UserManagement', 'as' => 'um.'], function () {
        Route::get('/', 'UserManageController@index')->name('index');
        Route::get('/create', 'UserManageController@FormInsert')->name('add');
        Route::get('/edit/{id}', 'UserManageController@FormEdit')->name('edit');
        Route::post('/', 'UserManageController@Store')->name('store');
        Route::put('/', 'UserManageController@Update')->name('update');
        //        Route::post('/UpdateStatus', 'FinishGoodAdjustController@ChangeStatus')->name('updateStatus');
        //        Route::get('/getDataForPDF/{docNo}', 'FinishGoodAdjustController@getDataForPDF')->name('pdf');
    });

    
    Route::group(['prefix' => 'Approve', 'as' => 'Approve.'], function () {
        // Route::get('/{xvpdtcode}', 'MasterItemSizeController@index')->name('index');
        Route::get('/', 'ApproveController@index')->name('index');
        Route::get('/po', 'POController@Approveindex')->name('po');
        Route::get('/order', 'OrderController@Approveindex')->name('order');
        Route::get('/gr', 'GRController@Approveindex')->name('gr');
        Route::get('/gi', 'GIController@Approveindex')->name('gi');
        Route::get('/adj', 'StockAdjustController@Approveindex')->name('adj');
        Route::get('/fr', 'FinishGoodReceiveController@Approveindex')->name('fr');
        Route::get('/fi', 'FinishGoodIssuedController@Apporoveindex')->name('fi');
        Route::get('/fa', 'FinishGoodAdjustController@Approveindex')->name('fa');
    });

    Route::group(['prefix' => 'MasterDesign', 'as' => 'design.'], function () {
        Route::get('/', 'MasterDesignController@index')->name('index');
        Route::get('/create', 'MasterDesignController@FormInsert')->name('add');
        Route::get('/edit/{XVOrhDocNo}', 'MasterDesignController@FormEdit')->name('edit');
        Route::get('/ajax/{XVOrhDocNo}', 'MasterDesignController@GetAjax')->name('ajax');
        Route::post('/', 'MasterDesignController@Store')->name('store');
        Route::put('/', 'MasterDesignController@Update')->name('update');
        Route::post('/UpdateStatus', 'MasterDesignController@ChangeStatus')->name('updateStatus');
        Route::get('/getDataForPDF/{docNo}', 'MasterDesignController@getDataForPDF')->name('pdf');
    });



    Route::get('material', 'MaterialController@material')->name('material');
    Route::get('frm_add_material', 'MaterialController@frm_add_material')->name('frm_add_material');
    Route::post('add_material', 'MaterialController@addMat')->name('add_material');
    Route::post('edit_material', 'MaterialController@editMat')->name('edit_material');
    Route::get('frm_edit_material/{id}', 'MaterialController@frm_edit_material')->name('frm_edit_material');
    Route::get('del_material/{id}', 'MaterialController@delMat')->name('del_material');
    // Route::get('material_mat','MaterialController@materialMat')->name('material_mat');
    Route::post('add_material_mat', 'MaterialController@addMatMat')->name('add_material_mat');
    Route::post('edit_material_mat', 'MaterialController@editMatMat')->name('edit_material_mat');
    Route::get('del_material_mat/{mat_code}/{unit_id}', 'MaterialController@delMatMat')->name('del_material_mat');
    // Supplier

    //    Route::group('prefix' => 'product', 'as' => 'product.'], function () {
    //        Route::get('/', 'ProductController@index')->name('index');
    //        Route::get('/AddProduct', 'ProductController@FormInsert')->name('add');
    //        Route::post('/', 'ProductController@Store')->name('store');
    //        Route::put('/', 'ProductController@Update')->name('update');
    //        Route::get('/editProduct/{id}', 'ProductController@FormEdit')->name('edit');
    //        Route::delete('/deleteProduct/{id}', 'ProductController@Delete')->name('delete');
    //    });
});
Route::get('/clear-cache', function () {

    Artisan::call('cache:clear');
    return "Cache is cleared";
});
Route::get('/clear-config', function () {

    Artisan::call('config:clear');
    return "Config is cleared";
});


// 'middleware' => ['CheckMenuPerm:19']