<?php $__env->startSection('header'); ?>
    <link href="<?php echo e(asset('css/gijgo.min.css')); ?>" rel="stylesheet" type="text/css"/>
    <link href="<?php echo e(asset('css/select2.min.css')); ?>" rel="stylesheet"/>
    <link rel="stylesheet" href="<?php echo e(asset('css/select2-bootstrap4.min.css')); ?>">

<?php $__env->stopSection(); ?>
<?php
    use Illuminate\Support\Facades\DB;
    $Material = DB::table('tmstmmaterial')->orderBy('xvmatcode','asc')->get()->toArray();
?>
<?php $__env->startSection('content'); ?>

    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>"/>
    <div class="card">
        <div class="card-body">
            <div class="row ">
                <div class="col-6">
                    <h5 style="font-weight: bold;">รายงานการรับเข้าวัสดุแยกตามวัสดุ</h5>
                </div>
                <div class="col-6 text-right">
                    <a href="<?php echo e(route('report.dashboard.index')); ?>" class="btn btn-danger ">ย้อนกลับ</a>
                </div>
            </div>
            <hr>
            <div class="card-body">
                <div class="row mt-1 ">
                    <div class="card " style="max-width: 650px;min-width: 650px;margin: auto;
                        padding: 10px;">
                        <div class="col-12 text-center mt-2">
                            <h6 style="font-weight: bold ">เงื่อนไขในการเลือก</h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-12 ">
                                    <h6 style="font-weight: bold">วันที่</h6>
                                    <input type="checkbox" class="mr-2" id="AllDate" onclick="AllDate()" checked>ทั้งหมด
                                    <div class="row mt-3">
                                        <p style="max-width: 100px;min-width: 100px;" class="ml-3 pr-2 text-right">
                                            ตั้งแต่วันที่</p>
                                        <input class="form-control" type="date" value="" name="DateStart" id="DateStart"
                                               style="max-width: 180px;min-width: 180px;">
                                        <p style="max-width: 100px;min-width: 100px;" class="ml-3  pr-2 text-right">
                                            ถึงวันที่</p>
                                        <input class="form-control" type="date" value="" name="DateEnd" id="DateEnd"
                                               style="max-width: 180px;min-width: 180px;">
                                    </div>
                                </div>
                            </div>
                            <div class="row mt-4">
                                <div class="col-12">
                                    <h6 style="font-weight: bold">วัสดุ</h6>
                                    <input type="checkbox" class="mr-2" id="AllMat" onclick="AllMat()" checked>ทั้งหมด
                                    <div class="row mt-2">
                                        <p style="max-width: 100px;min-width: 100px;" class="ml-3  pr-2 text-right">
                                            จาก</p>

                                        <select class="form-control " id="SelectMaterialStart" name="SelectMaterial"
                                                style="max-width: 480px;min-width: 480px;">
                                            <option></option>
                                            <?php $__currentLoopData = $Material; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($item->xvmatcode); ?>"> <?php echo e($item->xvmatcode); ?>

                                                    : <?php echo e($item->xvmatname); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>
                                    </div>
                                    <div class="row mt-2">
                                        <p style="max-width: 100px;min-width: 100px;" class="ml-3  pr-2 text-right">
                                            ถึง</p>
                                        <select class="form-control " id="SelectMaterialEnd" name="SelectMaterial"
                                                style="max-width: 480px;min-width: 480px;"
                                        >
                                            <option></option>
                                            <?php $__currentLoopData = $Material; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <option value="<?php echo e($item->xvmatcode); ?>"> <?php echo e($item->xvmatcode); ?>

                                                    : <?php echo e($item->xvmatname); ?></option>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </select>

                                    </div>
                                </div>

                            </div>
                        </div>
                        <div class="row mt-1">

                            <div class="col-8 text-right">
                                <button class="btn btn-info bottom " style="vertical-align: bottom;"
                                        onclick="datareport()">
                                    export pdf
                                </button>
                                <button class="btn btn-success bottom " style="vertical-align: bottom;" onclick="datareportexcel()">
                                    export
                                    excel
                                </button>
                            </div>
                        </div>
                        <div style=" visibility: hidden;" id="a">
                            <table id="example" ></table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <input type="hidden" id="MatStart">
    <input type="hidden" id="MatEnd">
    </div>
    <script src="<?php echo e(asset('js/pages/excel/table2excel.min.js')); ?>"></script>
    <script src="//unpkg.com/xlsx/dist/xlsx.full.min.js" type="text/javascript"></script>
    <script>
        $(document).ready(function () {
            AllMat();
            AllDate();

            const MatStart = $('#SelectMaterialStart').select2({
                placeholder: "กรุณาเลือกวัสดุ",
                theme: 'bootstrap4',
            });
            const MatEnd = $('#SelectMaterialEnd').select2({
                placeholder: "กรุณาเลือกวัสดุ",
                theme: 'bootstrap4',
            });
            MatStart.on('select2:select', function (e) {
                var {id, text} = (e.params.data);
                $("#MatStart").val(text.trim());
            });
            MatEnd.on('select2:select', function (e) {
                var {id, text} = (e.params.data);
                $("#MatEnd").val(text.trim());
            });
            Date.prototype.toDateInputValue = (function () {
                var local = new Date(this);
                local.setMinutes(this.getMinutes() - this.getTimezoneOffset());
                return local.toJSON().slice(0, 10);
            });

            document.getElementById('DateStart').value = new Date().toDateInputValue();
            document.getElementById('DateEnd').value = new Date().toDateInputValue();

        })
    </script>

    <script>
         function excel() {
            var wb = XLSX.utils.table_to_book(document.getElementById('example'));
            XLSX.writeFile(wb, '302 รายงานการรับเข้าวัสดุแยกตามวัสดุ ' + convertDateToLocale(new Date().toDateInputValue()) + '.xlsx');
            return false;
        }
        function AllMat() {
            var checkBox = document.getElementById("AllMat");
            if (checkBox.checked == true) {
                document.getElementById('SelectMaterialStart').disabled = true;
                document.getElementById('SelectMaterialEnd').disabled = true;
            } else {
                document.getElementById('SelectMaterialStart').disabled = false;
                document.getElementById('SelectMaterialEnd').disabled = false;
            }
        }

        function AllDate() {
            var checkBox = document.getElementById("AllDate");
            if (checkBox.checked == true) {
                document.getElementById('DateStart').disabled = true;
                document.getElementById('DateEnd').disabled = true;
            } else {
                document.getElementById('DateStart').disabled = false;
                document.getElementById('DateEnd').disabled = false;
            }
        }

        function datareport() {
            var dataSet = [];
            let _token = $('meta[name="csrf-token"]').attr('content');
            const DateStart = document.getElementById('DateStart').value;
            const DateEnd = document.getElementById('DateEnd').value;
            const MatStart = document.getElementById('SelectMaterialStart').value;
            const MatEnd = document.getElementById('SelectMaterialEnd').value;
            const isAllTime = document.getElementById('AllDate').checked;
            const isAllMat = document.getElementById('AllMat').checked;
            //ShowValue
            const XVMatStart = document.getElementById('MatStart').value;
            const XVMatEnd = document.getElementById('MatEnd').value;

            //End Show Value
            let JsonFilter = {
                DateStart,
                DateEnd,
                MatStart: XVMatStart,
                MatEnd: XVMatEnd,
                isAllTime,
                isAllMat,
            }
            $.ajax({
                url: '<?php echo e(route('report.302.data')); ?>',
                type: "POST",
                data: {
                    _token: _token,
                    DateStart,
                    DateEnd,
                    MatStart,
                    MatEnd,
                    isAllTime,
                    isAllMat,
                },
                success: function (result) {
                    console.log(result);
                    renderPdf(result, JsonFilter);
                }
            });
        }
        
        function datareportexcel() {
            var dataSet = [];
            let _token = $('meta[name="csrf-token"]').attr('content');
            const DateStart = document.getElementById('DateStart').value;
            const DateEnd = document.getElementById('DateEnd').value;
            const MatStart = document.getElementById('SelectMaterialStart').value;
            const MatEnd = document.getElementById('SelectMaterialEnd').value;
            const isAllTime = document.getElementById('AllDate').checked;
            const isAllMat = document.getElementById('AllMat').checked;
            //ShowValue
            const XVMatStart = document.getElementById('MatStart').value;
            const XVMatEnd = document.getElementById('MatEnd').value;

            //End Show Value
            let JsonFilter = {
                DateStart,
                DateEnd,
                MatStart: XVMatStart,
                MatEnd: XVMatEnd,
                isAllTime,
                isAllMat,
            }
            $.ajax({
                url: '<?php echo e(route('report.302.dataexcel')); ?>',
                type: "POST",
                data: {
                    _token: _token,
                    DateStart,
                    DateEnd,
                    MatStart,
                    MatEnd,
                    isAllTime,
                    isAllMat,
                },
                success: function (result) {
                    console.log(result);
                    var dataSet = [];
                    for (let index = 0; index < result.length; index++) {
                        var nf = new Intl.NumberFormat();

                        var row = [result[index].xvmatcode,
                            result[index].XVGrdName,
                            result[index].XDGrhDocDate,
                            result[index].XVGrhDocNo,
                            result[index].XIGrdQtyPo,
                            result[index].XIGrdQtyStk,
                            result[index].XVGrdUnitName+'/'+result[index].XIGrdFactor,

                        ];
                        dataSet.push(row);
                    }
                    $('table tbody').remove()
                    
                    $('#example').DataTable({
                        "destroy": true,
                        paging: false,
                        "data": dataSet,
                        "columns": [

                            {
                                "title": "รหัสวัสดุ",
                            },
                             {
                                "title": "ชื่อวัสดุ",
                            },
                            {
                                "title": "วันที่",
                            },
                            {
                                "title": "ใบรับวัสดุ",
                            },
                            {
                                "title": "จำนวนสั่ง",
                            },
                            {
                                "title": "จำนวนรับ",
                            },
                            {
                                "title": "หน่วย",
                            },
                        ]
                    });
                    
                    if(isAllTime)
                    {
                        
                        start = "ทั้งหมด";
                         end= "ทั้งหมด";
                    }
                    else
                    {
                        start = convertDateToLocale(DateStart);
                        end= convertDateToLocale(DateEnd);
                    }
                    if(isAllMat)
                    {
                        
                        matstart = "ทั้งหมด";
                         matend= "ทั้งหมด";
                    }
                    else
                    {
                        matstart =XVMatStart;
                        matend= XVMatEnd;
                    }

                  
                   
                    var htmltb = document.getElementById('example').innerHTML;
                    console.log(htmltb)
                    console.log(document.getElementsByTagName('thead')[0].innerHTML)
                    console.log(document.getElementsByTagName('tbody')[0].innerHTML)
                    document.getElementById('example').innerHTML =
                        "<thead>" +
                        "<tr><th  colspan='8' class='text-center'>302 รายงานการรับเข้าวัสดุแยกตามวัสดุ</th></tr>" +
                        "<tr><th  colspan='8' class='text-center'>จากวันที่ " + start + " ถึงวันที่ " + end +
                        "</th></tr> " +
                        "<tr><th  colspan='8' class='text-center'>จากผู้จำหน่าย " + matstart + " ถึง " + matend +
                        "</th></tr>" +
                        document.getElementsByTagName('thead')[0].innerHTML +
                        "</thead>" +
                        document.getElementsByTagName('tbody')[0].innerHTML;
                    excel();
                    $('table tbody').remove()
                    document.getElementById('a').innerHTML = " <table id='example' ></table>"
                }
            });
        }


        function convertDateToLocale(date) {
    return new Date(date).toLocaleDateString('th')
}
    </script>
<?php $__env->stopSection(); ?>
<script src="<?php echo e(asset('js/pages/report/R302.js')); ?>"></script>
<script src="<?php echo e(asset('js/jquery-3.5.1.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/gijgo.min.js')); ?>" defer type="text/javascript"></script>
<script src="<?php echo e(asset('js/select2.min.js')); ?>" defer></script>
<script src="<?php echo e(asset('js/sweetalert.min.js')); ?>"></script>
<script src="<?php echo e(asset('js/pdfmake.js')); ?>"></script>

<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\vk-2\resources\views/Report/index302.blade.php ENDPATH**/ ?>