<?php
    use Illuminate\Support\Facades\DB;
    $supplier = DB::table('tmstmsupplier')->orderBy('XVSplCode','desc')->get();
?>
<style>
    select[readonly].select2-hidden-accessible + .select2-container {
        pointer-events: none;
        touch-action: none;
    }

    select[readonly].select2-hidden-accessible + .select2-container .select2-selection {
        background: #eee;
        box-shadow: none;
    }

    select[readonly].select2-hidden-accessible + .select2-container .select2-selection__arrow, select[readonly].select2-hidden-accessible + .select2-container .select2-selection__clear {
        display: none;
    }
</style>
<input type="hidden" class="form-control" id="oldValueSupplier" value="<?php echo e($oldValue ?? ''); ?>">
<div class="form-group row mb-1 pb-0">
    <label class="col-md-4  col-xl-3 col-form-label">ผู้จัดจำหน่าย</label>
    <div class="col-xl-9" >
        <select class="form-control" id="SelectSupplier"
                <?php if(isset($isMultiple) && $isMultiple== true): ?> multiple <?php endif; ?>
                <?php if(isset($isRequired) && $isRequired== true): ?> required <?php endif; ?>
                <?php if(isset($isReadOnly) && $isReadOnly== true): ?> readonly <?php endif; ?>
                name="XVSplCode">
            <option></option>
            <?php $__currentLoopData = $supplier; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option
                    data-raw="<?php echo e(json_encode($item)); ?>"
                    <?php if(isset($oldValue) && $oldValue==$item->XVSplCode): ?>
                    selected
                    <?php endif; ?>
                    value="<?php echo e($item->XVSplCode); ?>"><?php echo e($item->XVSplCode); ?> <?php echo e($item->XVSplName); ?> <?php echo e($item->XVSplAddress); ?> <?php echo e($item->XVSplPhone); ?> <?php echo e($item->XVSplTaxID); ?> <?php echo e($item->XVSplEmail); ?> <?php echo e($item->XVSplFax); ?> <?php echo e($item->xvsqlcontactname); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>

</div>
<div class="form-group row mb-1 pb-0">
    <label class="col-md-4  col-xl-3 col-form-label">ชื่อผู้ติดต่อ</label>
    <div class="col">
        <input type="text" class="form-control col" name="xvsqlcontactname"
               readonly
               id="xvsqlcontactname">
    </div>

</div>
<div class="form-group row mb-1 pb-0">
    <label class="col-md-4  col-xl-3 col-form-label">ชื่อผู้จัดจำหน่าย</label>
    <div class="col">
        <input type="text" class="form-control" name="XVSplName"
               readonly
               id="XVSplName">
    </div>
</div>
<div class="form-group row mb-1 pb-0">
    <label class="col-md-4  col-xl-3 col-form-label">ที่อยู่</label>
    <div class="col">
       <textarea type="text" class="form-control" name="XVSplAddress"
                 readonly
                 id="XVSplAddress"
                 rows="2"></textarea>
    </div>
</div>
<div class="form-group row mb-1 pb-0">
    <label class="col-md-4  col-xl-3 col-form-label">โทรศัพท์</label>
    <div class="col">
        <input type="text" class="form-control" name="XVSplPhone"
               readonly
               id="XVSplPhone">
    </div>
</div>
<div class="form-group row mb-1 pb-0">
    <label class="col-md-4  col-xl-3 col-form-label">Fax</label>
    <div class="col">
        <input type="text" class="form-control col" name="XVSplFax"
               readonly
               id="XVSplFax">
    </div>
</div>
<div class="form-group row mb-0 pb-0">
    <label class="col-md-4  col-xl-3 col-form-label">Email</label>
    <div class="col">
        <input type="text" class="form-control" name="XVSplEmail"
               readonly
               id="XVSplEmail">
    </div>
</div>
<script>
    $(document).ready(function () {
        function i(id) {
            return document.getElementById(id);
        }

        const xvsqlcontactname = i('xvsqlcontactname');
        const XVSplName = i('XVSplName');
        const XVSplAddress = i('XVSplAddress');
        const XVSplPhone = i('XVSplPhone');
        const XVSplFax = i('XVSplFax');
        const XVSplEmail = i('XVSplEmail');

        const oldValueSupplier = i('oldValueSupplier')

        const supplier = $('#SelectSupplier').select2({
            placeholder: "เลือกผู้จัดจำหน่าย",
            theme: 'bootstrap4',
        });
        if (oldValueSupplier.value) {
            let rawData = supplier.find(':selected');
            rawData = JSON.parse(rawData[0].attributes[0].nodeValue)
            PushData(rawData)
        }
        $('#SelectSupplier').on('select2:select', function (e) {
            let rawData = JSON.parse(e.params.data?.element?.attributes[0]?.nodeValue) ?? [];
            PushData(rawData);
        });

        function PushData(rawData) {
            xvsqlcontactname.value = rawData.xvsqlcontactname
            XVSplName.value = rawData.XVSplName
            XVSplAddress.value = rawData.XVSplAddress
            XVSplPhone.value = rawData.XVSplPhone
            XVSplFax.value = rawData.XVSplFax
            XVSplEmail.value = rawData.XVSplEmail
        }
    })
</script>
<?php /**PATH C:\xampp\htdocs\vk-2\resources\views/Components/Supplier.blade.php ENDPATH**/ ?>